/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.redis.process;

import com.alibaba.fastjson.JSONObject;
import com.manatee.common.exception.BizException;
import com.manatee.common.util.StringUtil;
import com.manatee.lowcode.iutil.IOutputUtil;
import com.manatee.lowcode.iutil.IProcessConfUtil;
import com.manatee.lowcode.iutil.IVariableUtil;
import com.manatee.process.IProcess;
import com.manatee.process.domain.ProcessContent;
import com.manatee.process.domain.Step;
import com.manatee.redis.domain.DtQuery;
import com.manatee.redis.source.DtSourceManager;
import com.manatee.redis.util.RedisDbUtil;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class RedisValueIncreaseProcess
implements IProcess {
    @Resource
    private DtSourceManager dtSourceManager;
    @Resource
    private IOutputUtil outputUtil;
    @Resource
    private IVariableUtil variableUtil;
    @Resource
    private IProcessConfUtil processConfUtil;

    public void process(ProcessContent content) throws BizException {
        Step step = content.getStep();
        JSONObject conf = step.getConf();
        this.processConfUtil.checkConf(content, new String[]{"key"});
        this.incr(content, conf);
    }

    protected void incr(ProcessContent content, JSONObject conf) throws BizException {
        DtQuery query = this.getDtQuery(content, conf);
        Long incr = this.dtSourceManager.incr(query);
        this.outputUtil.handleAndPutData(content, (Object)incr);
    }

    private DtQuery getDtQuery(ProcessContent content, JSONObject conf) {
        DtQuery query = new DtQuery();
        String key = this.variableUtil.calVarInConf(content, "key");
        int db = RedisDbUtil.getRedisDB(content);
        query.setDbIndex(db);
        query.setKey(key);
        if (StringUtil.isBlank((String)conf.getString("returnKey"))) {
            content.getStepConf().put("returnKey", (Object)key);
        }
        if (conf.containsKey((Object)"isStaticRedis")) {
            query.setStaticRedis(conf.getBoolean("isStaticRedis"));
        }
        return query;
    }

    public String getName() {
        return "redisValueIncrease";
    }
}

