/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.common.util.tool.core.codec;

import com.manatee.common.util.tool.core.codec.Base62Codec;
import com.manatee.common.util.tool.core.io.FileUtil;
import com.manatee.common.util.tool.core.io.IoUtil;
import com.manatee.common.util.tool.core.util.CharsetUtil;
import com.manatee.common.util.tool.core.util.StrUtil;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;

public class Base62 {
    private static final Charset DEFAULT_CHARSET = CharsetUtil.CHARSET_UTF_8;
    private static final Base62Codec CODEC = Base62Codec.createGmp();

    public static String encode(CharSequence source) {
        return Base62.encode(source, DEFAULT_CHARSET);
    }

    public static String encode(CharSequence source, Charset charset) {
        return Base62.encode(StrUtil.bytes(source, charset));
    }

    public static String encode(byte[] source) {
        return new String(CODEC.encode(source));
    }

    public static String encode(InputStream in) {
        return Base62.encode(IoUtil.readBytes(in));
    }

    public static String encode(File file) {
        return Base62.encode(FileUtil.readBytes(file));
    }

    public static String decodeStrGbk(CharSequence source) {
        return Base62.decodeStr(source, CharsetUtil.CHARSET_GBK);
    }

    public static String decodeStr(CharSequence source) {
        return Base62.decodeStr(source, DEFAULT_CHARSET);
    }

    public static String decodeStr(CharSequence source, Charset charset) {
        return StrUtil.str(Base62.decode(source), charset);
    }

    public static File decodeToFile(CharSequence Base622, File destFile) {
        return FileUtil.writeBytes(Base62.decode(Base622), destFile);
    }

    public static void decodeToStream(CharSequence base62Str, OutputStream out, boolean isCloseOut) {
        IoUtil.write(out, isCloseOut, Base62.decode(base62Str));
    }

    public static byte[] decode(CharSequence base62Str) {
        return Base62.decode(StrUtil.bytes(base62Str, DEFAULT_CHARSET));
    }

    public static byte[] decode(byte[] base62bytes) {
        return CODEC.decode(base62bytes);
    }
}

