/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.common.util.tool.cache.impl;

import com.manatee.common.util.tool.cache.impl.AbstractCache;
import com.manatee.common.util.tool.cache.impl.CacheObj;
import java.util.Iterator;
import java.util.LinkedHashMap;

public class FIFOCache<K, V>
extends AbstractCache<K, V> {
    private static final long serialVersionUID = 1L;

    public FIFOCache(int capacity) {
        this(capacity, 0L);
    }

    public FIFOCache(int capacity, long timeout) {
        this.capacity = capacity;
        this.timeout = timeout;
        this.cacheMap = new LinkedHashMap(Math.max(16, capacity >>> 7), 1.0f, false);
    }

    @Override
    protected int pruneCache() {
        int count = 0;
        CacheObj first = null;
        Iterator values = this.cacheMap.values().iterator();
        while (values.hasNext()) {
            CacheObj co = (CacheObj)values.next();
            if (co.isExpired()) {
                values.remove();
                ++count;
            }
            if (first != null) continue;
            first = co;
        }
        if (this.isFull() && null != first) {
            this.cacheMap.remove(first.key);
            this.onRemove(first.key, first.obj);
            ++count;
        }
        return count;
    }
}

