/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.process.util;

import com.manatee.common.util.tool.core.util.StrUtil;
import com.manatee.lowcode.exp.manager.FormatManateeExpUtil;
import com.manatee.manager.node.domain.FormConvertContent;
import java.util.Arrays;
import java.util.EmptyStackException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;

public class ExpressionUtil {
    public static Map<String, String> symbolMap = new ConcurrentHashMap<String, String>();

    public static Map<Integer, Integer> getBracketsMapping(String a) {
        int n;
        Stack<Integer> stack = new Stack<Integer>();
        HashMap<Integer, Integer> hashMap = new HashMap<Integer, Integer>();
        int n2 = n = 0;
        while (n2 < a.length()) {
            if (a.charAt(n) == '(') {
                stack.add(n + 1);
                hashMap.put(n, null);
            } else if (a.charAt(n) == ')') {
                int n3 = (Integer)stack.pop();
                if (n3 > 0) {
                    hashMap.put(n3 - 1, n);
                } else if (n3 == 0) {
                    stack.add(0);
                }
            }
            n2 = ++n;
        }
        return hashMap;
    }

    public ExpressionUtil() {
        ExpressionUtil a;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isValid(String a) {
        try {
            int n;
            Stack<String> stack = new Stack<String>();
            int n2 = n = 0;
            while (n2 < a.length()) {
                String string = a.charAt(n) + "";
                if (a.charAt(n) == '(') {
                    stack.push(string);
                } else if (a.charAt(n) == ')' && (String)stack.pop() == null) {
                    return false;
                }
                n2 = ++n;
            }
            return stack.size() == 0;
        }
        catch (EmptyStackException emptyStackException) {
            return false;
        }
    }

    public static String formatSymbolBack(String a) {
        Iterator<Map.Entry<String, String>> iterator;
        String string = a;
        Iterator<Map.Entry<String, String>> iterator2 = iterator = symbolMap.entrySet().iterator();
        while (iterator2.hasNext()) {
            Object object = iterator.next();
            String string2 = object.getValue();
            object = object.getKey();
            string = StringUtils.replace((String)string, (String)string2, (String)object);
            iterator2 = iterator;
        }
        return string;
    }

    public static List<String> getConditionList(String a) {
        String string = a;
        List<String> list = ExpressionUtil.getBracketsMapping(string).entrySet();
        HashSet<Map.Entry> hashSet = new HashSet<Map.Entry>();
        for (Map.Entry entry : list) {
            Integer n = (Integer)entry.getKey();
            Integer n2 = (Integer)entry.getValue();
            if (n == 0) {
                string = StrUtil.replace((CharSequence)string, (int)n, (int)(n + 1), (char)' ');
                string = StrUtil.replace((CharSequence)string, (int)n2, (int)(n2 + 1), (char)' ');
                hashSet.add(entry);
                continue;
            }
            if (n <= 0) continue;
            String string2 = ExpressionUtil.ALLATORIxDEMO(string, n);
            if (!FormatManateeExpUtil.ALLATORIxDEMO("\u0002").equals(string2) && !FormConvertContent.ALLATORIxDEMO("T").equals(string2) && !"|".equals(string2)) continue;
            string = StrUtil.replace((CharSequence)string, (int)n, (int)(n + 1), (char)' ');
            string = StrUtil.replace((CharSequence)string, (int)n2, (int)(n2 + 1), (char)' ');
            hashSet.add(entry);
        }
        string = string.trim();
        string = string.replaceAll(FormatManateeExpUtil.ALLATORIxDEMO("w\f"), FormConvertContent.ALLATORIxDEMO("^=^"));
        string = string.replaceAll(FormatManateeExpUtil.ALLATORIxDEMO("\f"), FormConvertContent.ALLATORIxDEMO("^=^"));
        string = string.replaceAll(FormatManateeExpUtil.ALLATORIxDEMO("\rV\rV"), FormConvertContent.ALLATORIxDEMO("^=^"));
        string = string.replaceAll("\\|", FormatManateeExpUtil.ALLATORIxDEMO("\u0006}\u0006"));
        list = Arrays.asList(StrUtil.split((CharSequence)string, (CharSequence)FormConvertContent.ALLATORIxDEMO("^=^")));
        return list;
    }

    public static String specialSymbolHandle(String a) {
        String string = a;
        String[] stringArray = StringUtils.substringsBetween((String)string, (String)FormConvertContent.ALLATORIxDEMO("P"), (String)FormatManateeExpUtil.ALLATORIxDEMO("\b"));
        if (stringArray != null && stringArray.length > 0) {
            int n;
            int n2 = stringArray.length;
            int n3 = n = 0;
            while (n3 < n2) {
                String string2 = stringArray[n];
                String string3 = ExpressionUtil.specialSymbolReplace(string2);
                StringUtils.replace((String)a, (String)(FormConvertContent.ALLATORIxDEMO("P") + string2 + FormatManateeExpUtil.ALLATORIxDEMO("\b")), (String)new StringBuilder().insert(0, FormConvertContent.ALLATORIxDEMO("P")).append(string3).append(FormatManateeExpUtil.ALLATORIxDEMO("\b")).toString(), (int)1);
                n3 = ++n;
            }
        }
        return string;
    }

    public static void main(String[] a) {
        System.out.println(FormConvertContent.ALLATORIxDEMO("x2Q2Q2Q2Q2Q2Q2Q2Q2Q2Q2Q2Q2Q2Q2Q2Q2Q2Q2Q2Q2Q2Q2Q2Q\u001bQ1R1R1R1R1R1R1R1R1R1R1R1R1R1R1R1R1R1R1R1R1R1R1R2x2R1R1R1R1Q2R2R1R2R1R1Q2R2Q2R2Q2R2Q1R2Q2R1R1R1R1Q\u001bQ1R1R1R1Q1Q1Q1R1Q1R1Q1Q1R2R1Q1Q1Q1Q1R2R1R1R1R1R2x2R1R1R1R2Q2R2R1R2R1R2Q2R1Q1R2R2R2Q1R1Q1R1R1R1R1Q\u001bQ1R1R1R1Q1Q1Q2Q1Q2Q1Q1Q1R2R1Q2Q1Q1Q1Q2Q1R1R1R1R2x2R1R1R1R1R1R1R1R1R1R1R1R1R1R1R1R1R1R1R1R1R1R1R1Q\u001bQ1=s\u0014d\u0001r\u0013e\u001b~\u001c1\u0010hRP\u001e}\u0013e\u001dc\u001b1=s\u0014d\u0001r\u0013e\u001dcRgE?E16T?^R2x2R1R1R1R1R1R1R1R1R1R1R1R1R1R1R1R1R1R1R1R1R1R1R1Q\u001bQ1R1R1R1R1R1\u001ae\u0006aH>]f\u0005f\\p\u001e}\u0013e\u001dc\u001b?\u0011~\u001f1R1R1R1R1R1R2x2R1R1R1R1R1R1R1R1R1R1R1R1R1R1R1R1R1R1R1R1R1R1R1Q\u001bQ2Q2Q2Q2Q2Q2Q2Q2Q2Q2Q2Q2Q2Q2Q2Q2Q2Q2Q2Q2Q2Q2Q2Q2x"));
        ExpressionUtil.getConditionList(FormatManateeExpUtil.ALLATORIxDEMO("\"C+OyF8Y%k5NyF8Y%\u0003x\n8YqD>^qD$F=\nw\fq\u00025K%K\"E$X2OqY%K#^\"}8^9\nsB%^!\u0010~\u0005s\n-VqN0^0Y>_#I4\n\"^0X%Y\u0006C%Bq\b9^%Z\"\u0010~\u0005s\u0003"));
    }

    static {
        symbolMap.put(FormConvertContent.ALLATORIxDEMO("Z"), FormatManateeExpUtil.ALLATORIxDEMO("\trr\u001abr\t"));
        symbolMap.put(FormConvertContent.ALLATORIxDEMO("["), FormatManateeExpUtil.ALLATORIxDEMO("r\t\br\u001abr\t"));
        symbolMap.put(",", "##DH##");
        symbolMap.put("|", FormConvertContent.ALLATORIxDEMO("Q2:D=2Q"));
        symbolMap.put(FormatManateeExpUtil.ALLATORIxDEMO("\f"), FormConvertContent.ALLATORIxDEMO("Q2+D<2Q"));
    }

    public static boolean isContainsFun(String a) {
        return a.contains(FormConvertContent.ALLATORIxDEMO("Z")) || a.contains(FormatManateeExpUtil.ALLATORIxDEMO("\u0003"));
    }

    public static String specialSymbolReplace(String a) {
        Iterator<Map.Entry<String, String>> iterator;
        String string = a;
        Iterator<Map.Entry<String, String>> iterator2 = iterator = symbolMap.entrySet().iterator();
        while (iterator2.hasNext()) {
            Object object = iterator.next();
            String string2 = object.getKey();
            object = object.getValue();
            string = StringUtils.replace((String)string, (String)string2, (String)object);
            iterator2 = iterator;
        }
        return string;
    }

    private static /* synthetic */ String ALLATORIxDEMO(String a, int a2) {
        if (a2 < 1) {
            return null;
        }
        String string = a.substring(a2 - 1, a2);
        if (FormatManateeExpUtil.ALLATORIxDEMO("\n").equals(string)) {
            return ExpressionUtil.ALLATORIxDEMO(a, a2 - 1);
        }
        return string;
    }
}

