/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.lowcodedb.base;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.manatee.common.domain.DBQuery;
import com.manatee.common.domain.ResultCode;
import com.manatee.common.exception.BizException;
import com.manatee.common.util.StringUtil;
import com.manatee.common.util.tool.core.util.StrUtil;
import com.manatee.lowcode.iutil.IDbReadUtil;
import com.manatee.lowcodedb.base.DBReadBase;
import com.manatee.lowcodedb.handle.DBHandle;
import com.manatee.lowcodedb.handle.DBHandleUtil;
import com.manatee.lowcodedb.newdb.DbUtil;
import com.manatee.lowcodedb.newdb.handler.ManateeListHandler;
import com.manatee.lowcodedb.newdb.meta.MetaUtil;
import com.manatee.lowcodedb.newdb.sql.SqlExecutor;
import com.manatee.lowcodedb.newdb.sql.SqlLog;
import com.manatee.process.domain.ProcessContent;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Service;

@Primary
@Service
public class DBReadUtil
extends DBReadBase
implements IDbReadUtil {
    @Resource
    private DBHandleUtil dbHandleUtil;

    public JSONArray getTableColumns(String db) throws BizException {
        return this.getTableColumns(db, null);
    }

    public JSONArray getTableColumnsBySchema(String db, String schema) throws BizException {
        return this.getTableColumnsBySchema(db, null, schema);
    }

    public JSONArray getTableColumns(String db, String searchTableName) throws BizException {
        return this.getTableColumnsUtil(db, searchTableName, null, null);
    }

    public JSONArray getTableColumnsBySchema(String db, String searchTableName, String schema) throws BizException {
        return this.getTableColumnsUtil(db, searchTableName, null, schema);
    }

    public JSONArray getTableNameListColumns(String db, List<String> searchTableNameList) throws BizException {
        if (searchTableNameList == null || searchTableNameList.isEmpty()) {
            return this.getTableColumns(db, null);
        }
        return this.getTableColumnsUtil(db, null, searchTableNameList, null);
    }

    private JSONArray getTableColumnsUtil(String db, String searchTableName, List<String> searchTableNameList, String schema) throws BizException {
        JSONObject tableJson = new JSONObject(true);
        JSONArray tableJsonArray = new JSONArray();
        boolean camel = true;
        List<Map<String, Object>> tableColumns = searchTableNameList != null && !searchTableNameList.isEmpty() ? this.getColumns(db, searchTableNameList, schema) : this.getColumns(db, searchTableName, schema);
        for (Map<String, Object> tableColumn : tableColumns) {
            String tableName = tableColumn.get("tableName").toString();
            String columnName = tableColumn.get("columnName").toString();
            JSONObject columnJson = tableJson.containsKey((Object)tableName) ? tableJson.getJSONObject(tableName) : new JSONObject(true);
            if (camel) {
                columnJson.put(columnName, (Object)this.camelCase(columnName.toLowerCase()));
            } else {
                columnJson.put(columnName, (Object)columnName);
            }
            tableJson.put(tableName, (Object)columnJson);
        }
        for (String tableName : tableJson.keySet()) {
            JSONObject tableColumnJson = new JSONObject();
            tableColumnJson.put("name", (Object)tableName);
            tableColumnJson.put("value", (Object)tableName);
            StringBuilder columnSb = new StringBuilder();
            JSONObject tableNameColumns = tableJson.getJSONObject(tableName);
            for (String columnName : tableNameColumns.keySet()) {
                columnSb = columnSb.append(columnName).append(" = ").append(tableNameColumns.get((Object)columnName)).append(";\n");
            }
            tableColumnJson.put("columns", (Object)columnSb);
            tableJsonArray.add((Object)tableColumnJson);
        }
        return tableJsonArray;
    }

    public List<Map<String, Object>> getColumns(String db, String table, String schema) throws BizException {
        return this.getColumnsUtil(db, table, null, schema);
    }

    public List<Map<String, Object>> getColumns(String db, List<String> tableNameList, String schema) throws BizException {
        return this.getColumnsUtil(db, null, tableNameList, schema);
    }

    public List<Map<String, Object>> getColumnsUtil(String db, String table, List<String> tableNameList, String schema) throws BizException {
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        Statement ps = null;
        Connection con = null;
        ResultSet rs = null;
        try {
            con = this.manateeDataSource.getConnection(db);
            StringBuilder sqlSb = new StringBuilder();
            String databaseProductName = con.getMetaData().getDatabaseProductName().toLowerCase();
            DBHandle dbHandle = this.dbHandleUtil.getDBHandle(databaseProductName);
            String oldSchema = schema;
            if (StringUtil.equals((CharSequence)databaseProductName, (CharSequence)"oracle")) {
                schema = null;
            }
            sqlSb = tableNameList != null && !tableNameList.isEmpty() ? dbHandle.initTableNameListSql(con, sqlSb, tableNameList, schema) : dbHandle.initTablesSql(con, sqlSb, table, schema);
            rs = this.executeSelectSql(sqlSb.toString(), con, (PreparedStatement)ps);
            if (StringUtil.equals((CharSequence)databaseProductName, (CharSequence)"oracle") && StringUtil.isNotBlank((String)oldSchema) && !StringUtil.equals((CharSequence)con.getSchema(), (CharSequence)oldSchema)) {
                ArrayList<Map<String, Object>> arrayList = list;
                return arrayList;
            }
            if (rs == null) {
                ArrayList<Map<String, Object>> arrayList = list;
                return arrayList;
            }
            DBQuery dbQuery = new DBQuery();
            dbQuery.setCamelCase(Boolean.valueOf(true));
            while (rs.next()) {
                Map<String, Object> aMap = this.convertMap(rs, dbQuery);
                list.add(aMap);
            }
        }
        catch (SQLException e) {
            throw new BizException(ResultCode.SYSTEM_ERROR, (Throwable)e);
        }
        finally {
            try {
                if (ps != null) {
                    ps.close();
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            try {
                if (con != null) {
                    con.close();
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        return list;
    }

    public List<String> getSchemasUtil(String db, String schema) throws BizException {
        ArrayList<String> list = new ArrayList();
        Connection conn = null;
        try {
            conn = this.manateeDataSource.getConnection(db);
            String databaseProductName = conn.getMetaData().getDatabaseProductName().toLowerCase();
            DBHandle dbHandle = this.dbHandleUtil.getDBHandle(databaseProductName);
            list = dbHandle.getSchemas(conn);
        }
        catch (SQLException e) {
            try {
                throw new BizException(ResultCode.SYSTEM_ERROR, (Throwable)e);
            }
            catch (Throwable throwable) {
                DbUtil.close(conn);
                throw throwable;
            }
        }
        DbUtil.close(conn);
        return list;
    }

    public JSONArray getTableBySchemaUtil(String db, String schema) throws BizException {
        return this.getTableBySchemaUtil(db, schema, null);
    }

    public JSONArray getTableBySchemaUtil(String db, String schema, String searchTableName) throws BizException {
        JSONArray tableJsonArray = new JSONArray();
        Connection conn = null;
        try {
            List<String> list;
            conn = this.manateeDataSource.getConnection(db);
            String databaseProductName = conn.getMetaData().getDatabaseProductName().toLowerCase();
            DBHandle dbHandle = this.dbHandleUtil.getDBHandle(databaseProductName);
            if ((StrUtil.isBlank((CharSequence)schema) || "null".equalsIgnoreCase(schema)) && (StrUtil.isBlank((CharSequence)(schema = MetaUtil.getSchema(conn))) || "null".equalsIgnoreCase(schema))) {
                schema = MetaUtil.getCatalog(conn);
            }
            if ((list = dbHandle.getTablesBySchema(conn, schema, null)) != null && list.size() > 0) {
                int index = 1;
                String tableLowerCas = null;
                String tableUpperCase = null;
                if (StringUtils.isNotEmpty((CharSequence)searchTableName)) {
                    tableLowerCas = searchTableName.toLowerCase();
                    tableUpperCase = searchTableName.toUpperCase();
                }
                for (String tableName : list) {
                    if (searchTableName != null && !tableName.contains(tableLowerCas) && !tableName.contains(tableUpperCase)) continue;
                    JSONObject tableColumnJson = new JSONObject();
                    tableColumnJson.put("name", (Object)tableName);
                    tableColumnJson.put("value", (Object)tableName);
                    tableJsonArray.add((Object)tableColumnJson);
                    if (index >= 10) break;
                    ++index;
                }
            }
        }
        catch (SQLException e) {
            try {
                throw new BizException(ResultCode.SYSTEM_ERROR, (Throwable)e);
            }
            catch (Throwable throwable) {
                DbUtil.close(conn);
                throw throwable;
            }
        }
        DbUtil.close(conn);
        return tableJsonArray;
    }

    public JSONObject getColumnNamesBySchemaAndTableUtil(String db, String schema, String searchTableName) throws BizException {
        JSONObject columnJson = new JSONObject();
        Connection conn = null;
        try {
            List<String> list;
            conn = this.manateeDataSource.getConnection(db);
            String databaseProductName = conn.getMetaData().getDatabaseProductName().toLowerCase();
            DBHandle dbHandle = this.dbHandleUtil.getDBHandle(databaseProductName);
            if ((StrUtil.isBlank((CharSequence)schema) || "null".equalsIgnoreCase(schema)) && (StrUtil.isBlank((CharSequence)(schema = MetaUtil.getSchema(conn))) || "null".equalsIgnoreCase(schema))) {
                schema = MetaUtil.getCatalog(conn);
            }
            if ((list = dbHandle.getColumnNamesBySchemaAndTable(conn, schema, searchTableName)) != null && list.size() > 0) {
                StringBuilder columnSb = new StringBuilder();
                for (String columnName : list) {
                    columnSb = columnSb.append(columnName).append(" = ").append(this.newCamelCase(columnName)).append(";\n");
                }
                columnJson.put("columns", (Object)columnSb);
                columnJson.put("name", (Object)searchTableName);
                columnJson.put("value", (Object)searchTableName);
            }
        }
        catch (SQLException e) {
            try {
                throw new BizException(ResultCode.SYSTEM_ERROR, (Throwable)e);
            }
            catch (Throwable throwable) {
                DbUtil.close(conn);
                throw throwable;
            }
        }
        DbUtil.close(conn);
        return columnJson;
    }

    public int executeNotSelectSql(DBQuery dbQuery, Connection transactionCon) throws BizException {
        Statement ps = null;
        Connection con = null;
        try {
            int count;
            con = transactionCon != null ? transactionCon : this.manateeDataSource.getConnection(dbQuery.getDb());
            ps = con.prepareStatement(dbQuery.getSql());
            int n = count = this.executeNotSelectSql(dbQuery.getSql(), con, (PreparedStatement)ps);
            return n;
        }
        catch (SQLException e) {
            String message = e.getMessage();
            String mysqlNonUpdate1 = "Can not issue executeUpdate() or executeLargeUpdate() for SELECTs";
            String mysqlNonUpdate2 = "Can not issue executeUpdate() or executeLargeUpdate() with statements that produce result sets";
            String damengNonUpdate = "\u975e\u6cd5\u7684SQL\u8bed\u53e5\u7c7b\u578b";
            String pgsqlNonUpdate = "\u4f20\u56de\u9884\u671f\u4e4b\u5916\u7684\u7ed3\u679c";
            String sqlServerNonUpdate = "The executeUpdate method must not return a result set.";
            if (message.contains(mysqlNonUpdate1) || message.contains(mysqlNonUpdate2) || message.contains(damengNonUpdate) || message.contains(pgsqlNonUpdate) || message.contains(sqlServerNonUpdate)) {
                Throwable cause = e.getCause();
                Throwable throwable = new Throwable("\u5f53\u524d\u8bed\u53e5\u4e3a\u67e5\u8be2\u8bed\u53e5\uff0c\u4e0d\u53ef\u4f7f\u7528\u975e\u67e5\u8be2\u7c7b\u578b\u6267\u884c", cause);
                throw new BizException(ResultCode.SYSTEM_ERROR, throwable);
            }
            throw new BizException(ResultCode.SYSTEM_ERROR, (Throwable)e);
        }
        finally {
            try {
                if (ps != null) {
                    ps.close();
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            if (transactionCon == null) {
                try {
                    if (con != null) {
                        con.close();
                    }
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public int executeNotSelectSqlV2(DBQuery dbQuery, Connection transactionCon, ProcessContent content) throws BizException {
        Statement ps = null;
        Connection con = null;
        try {
            con = transactionCon != null ? transactionCon : this.manateeDataSource.getConnection(dbQuery.getDb());
            int count = 0;
            ps = con.prepareStatement(dbQuery.getSql());
            Long manateeProcessVersion = content.getStepConf().getLong("manateeProcessVersion");
            if (manateeProcessVersion != null && manateeProcessVersion >= 404010200L) {
                ArrayList paramsList = (ArrayList)content.getStepConf().get((Object)"manateeSqlProcessParamValues");
                if (paramsList == null) {
                    paramsList = new ArrayList();
                }
                SqlLog.INSTANCE.log(dbQuery.getSql(), paramsList);
                count = SqlExecutor.executeUpdate((PreparedStatement)ps, paramsList.toArray());
            } else {
                SqlLog.INSTANCE.log(dbQuery.getSql());
                count = this.executeNotSelectSql(dbQuery.getSql(), con, (PreparedStatement)ps);
            }
            int paramsList = count;
            return paramsList;
        }
        catch (SQLException e) {
            String message = e.getMessage();
            String mysqlNonUpdate1 = "Can not issue executeUpdate() or executeLargeUpdate() for SELECTs";
            String mysqlNonUpdate2 = "Can not issue executeUpdate() or executeLargeUpdate() with statements that produce result sets";
            String damengNonUpdate = "\u975e\u6cd5\u7684SQL\u8bed\u53e5\u7c7b\u578b";
            String pgsqlNonUpdate = "\u4f20\u56de\u9884\u671f\u4e4b\u5916\u7684\u7ed3\u679c";
            String sqlServerNonUpdate = "The executeUpdate method must not return a result set.";
            if (message.contains(mysqlNonUpdate1) || message.contains(mysqlNonUpdate2) || message.contains(damengNonUpdate) || message.contains(pgsqlNonUpdate) || message.contains(sqlServerNonUpdate)) {
                Throwable cause = e.getCause();
                Throwable throwable = new Throwable("\u5f53\u524d\u8bed\u53e5\u4e3a\u67e5\u8be2\u8bed\u53e5\uff0c\u4e0d\u53ef\u4f7f\u7528\u975e\u67e5\u8be2\u7c7b\u578b\u6267\u884c", cause);
                throw new BizException(ResultCode.SYSTEM_ERROR, throwable);
            }
            throw new BizException(ResultCode.SYSTEM_ERROR, (Throwable)e);
        }
        finally {
            try {
                if (ps != null) {
                    ps.close();
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            if (transactionCon == null) {
                try {
                    if (con != null) {
                        con.close();
                    }
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public int executeNotSelectStatementSql(DBQuery dbQuery, Connection transactionCon) throws BizException {
        Statement ps = null;
        Connection con = null;
        try {
            con = transactionCon != null ? transactionCon : this.manateeDataSource.getConnection(dbQuery.getDb());
            ps = con.createStatement();
            int n = ps.executeUpdate(dbQuery.getSql());
            return n;
        }
        catch (SQLException e) {
            throw new BizException(ResultCode.SYSTEM_ERROR, (Throwable)e);
        }
        finally {
            try {
                if (ps != null) {
                    ps.close();
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            if (transactionCon == null) {
                try {
                    if (con != null) {
                        con.close();
                    }
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public JSON executeSelectSql(DBQuery dbQuery, ProcessContent content) throws BizException {
        List<Object> list = new ArrayList<Map<String, Object>>();
        Statement ps = null;
        Connection con = null;
        ResultSet rs = null;
        try {
            con = this.manateeDataSource.getConnection(dbQuery.getDb());
            Long manateeProcessVersion = null;
            if (content != null) {
                manateeProcessVersion = content.getStepConf().getLong("manateeProcessVersion");
            }
            if (manateeProcessVersion != null && manateeProcessVersion >= 404010200L) {
                ArrayList paramsList = (ArrayList)content.getStepConf().get((Object)"manateeSqlProcessParamValues");
                if (paramsList == null) {
                    paramsList = new ArrayList();
                }
                list = SqlExecutor.query(con, dbQuery.getSql(), new ManateeListHandler(false, dbQuery.getCamelCase(), dbQuery.getUpperOrLowerCase()), paramsList.toArray());
            } else {
                SqlLog.INSTANCE.log(dbQuery.getSql());
                rs = this.executeSelectSql(dbQuery.getSql(), con, (PreparedStatement)ps);
                if (rs == null) {
                    JSON paramsList = null;
                    return paramsList;
                }
                while (rs.next()) {
                    Map<String, Object> aMap = this.convertMap(rs, dbQuery, content);
                    list.add(aMap);
                }
            }
        }
        catch (SQLException e) {
            String message = e.getMessage();
            String oracleNonQuery = "ORA-01002";
            String mysqlNonQuery1 = "Statement.executeQuery() cannot issue statements that do not produce result sets.";
            String mysqlNonQuery2 = "Can not issue data manipulation statements with executeQuery().";
            String pgsqlNonQuery = "\u67e5\u8be2\u6ca1\u6709\u4f20\u56de\u4efb\u4f55\u7ed3\u679c";
            String sqlServerNonQuery = "The executeQuery method must return a result set.";
            if (message.contains(oracleNonQuery) || message.contains(mysqlNonQuery1) || message.contains(mysqlNonQuery2) || message.contains(pgsqlNonQuery) || message.contains(sqlServerNonQuery)) {
                Throwable cause = e.getCause();
                Throwable throwable = new Throwable("\u5f53\u524d\u8bed\u53e5\u4e3a\u975e\u67e5\u8be2\u8bed\u53e5\uff0c\u4e0d\u53ef\u4f7f\u7528\u67e5\u8be2\u7c7b\u578b\u6267\u884c", cause);
                throw new BizException(ResultCode.SYSTEM_ERROR, throwable);
            }
            throw new BizException(ResultCode.SYSTEM_ERROR, (Throwable)e);
        }
        finally {
            try {
                if (ps != null) {
                    ps.close();
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            try {
                if (con != null) {
                    con.close();
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        if (dbQuery.getSelectOne().booleanValue()) {
            JSONObject jsonObject = list.size() > 0 ? new JSONObject((Map)list.get(0)) : null;
            return jsonObject;
        }
        JSONArray dataArray = new JSONArray();
        dataArray.addAll(list);
        return dataArray;
    }

    public JSON executeSelectSqlV2(DBQuery dbQuery, ProcessContent content) throws BizException {
        List<Object> list = new ArrayList<Map<String, Object>>();
        Statement ps = null;
        Connection con = null;
        ResultSet rs = null;
        Connection transactionCon = content.getTransactionCon();
        try {
            con = transactionCon != null ? transactionCon : this.manateeDataSource.getConnection(dbQuery.getDb());
            Long manateeProcessVersion = content.getStepConf().getLong("manateeProcessVersion");
            if (manateeProcessVersion != null && manateeProcessVersion >= 404010200L) {
                ArrayList paramsList = (ArrayList)content.getStepConf().get((Object)"manateeSqlProcessParamValues");
                if (paramsList == null) {
                    paramsList = new ArrayList();
                }
                list = SqlExecutor.query(con, dbQuery.getSql(), new ManateeListHandler(false, dbQuery.getCamelCase(), dbQuery.getUpperOrLowerCase()), paramsList.toArray());
            } else {
                SqlLog.INSTANCE.log(dbQuery.getSql());
                rs = this.executeSelectSql(dbQuery.getSql(), con, (PreparedStatement)ps);
                if (rs == null) {
                    JSON paramsList = null;
                    return paramsList;
                }
                while (rs.next()) {
                    Map<String, Object> aMap = this.convertMap(rs, dbQuery, content);
                    list.add(aMap);
                }
            }
        }
        catch (SQLException e) {
            String message = e.getMessage();
            String oracleNonQuery = "ORA-01002";
            String mysqlNonQuery1 = "Statement.executeQuery() cannot issue statements that do not produce result sets.";
            String mysqlNonQuery2 = "Can not issue data manipulation statements with executeQuery().";
            String pgsqlNonQuery = "\u67e5\u8be2\u6ca1\u6709\u4f20\u56de\u4efb\u4f55\u7ed3\u679c";
            String sqlServerNonQuery = "The executeQuery method must return a result set.";
            if (message.contains(oracleNonQuery) || message.contains(mysqlNonQuery1) || message.contains(mysqlNonQuery2) || message.contains(pgsqlNonQuery) || message.contains(sqlServerNonQuery)) {
                Throwable cause = e.getCause();
                Throwable throwable = new Throwable("\u5f53\u524d\u8bed\u53e5\u4e3a\u975e\u67e5\u8be2\u8bed\u53e5\uff0c\u4e0d\u53ef\u4f7f\u7528\u67e5\u8be2\u7c7b\u578b\u6267\u884c", cause);
                throw new BizException(ResultCode.SYSTEM_ERROR, throwable);
            }
            throw new BizException(ResultCode.SYSTEM_ERROR, (Throwable)e);
        }
        finally {
            try {
                if (ps != null) {
                    ps.close();
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            if (transactionCon == null) {
                try {
                    if (con != null) {
                        con.close();
                    }
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        if (dbQuery.getSelectOne().booleanValue()) {
            JSONObject jsonObject = list.size() > 0 ? new JSONObject((Map)list.get(0)) : null;
            return jsonObject;
        }
        JSONArray dataArray = new JSONArray();
        dataArray.addAll(list);
        return dataArray;
    }

    public JSON executeCallSql(DBQuery dbQuery, ProcessContent content) throws BizException {
        JSONObject resultJson = new JSONObject();
        Connection con = null;
        ResultSet rs = null;
        Connection transactionCon = content.getTransactionCon();
        try {
            con = transactionCon != null ? transactionCon : this.manateeDataSource.getConnection(dbQuery.getDb());
            ArrayList paramsList = (ArrayList)content.getStepConf().get((Object)"manateeSqlProcessParamValues");
            if (paramsList == null) {
                paramsList = new ArrayList();
            }
            Map outParams = (Map)content.getStepConf().get((Object)"manateeSqlProcessOutParams");
            resultJson = (JSONObject)SqlExecutor.executeCall(con, dbQuery.getSql(), new ManateeListHandler(false, dbQuery.getCamelCase(), dbQuery.getUpperOrLowerCase()), outParams, paramsList.toArray());
        }
        catch (SQLException e) {
            String message = e.getMessage();
            String oracleNonQuery = "ORA-01002";
            String mysqlNonQuery1 = "Statement.executeQuery() cannot issue statements that do not produce result sets.";
            String mysqlNonQuery2 = "Can not issue data manipulation statements with executeQuery().";
            String pgsqlNonQuery = "\u67e5\u8be2\u6ca1\u6709\u4f20\u56de\u4efb\u4f55\u7ed3\u679c";
            String sqlServerNonQuery = "The executeQuery method must return a result set.";
            if (message.contains(oracleNonQuery) || message.contains(mysqlNonQuery1) || message.contains(mysqlNonQuery2) || message.contains(pgsqlNonQuery) || message.contains(sqlServerNonQuery)) {
                Throwable cause = e.getCause();
                Throwable throwable = new Throwable("\u5f53\u524d\u8bed\u53e5\u4e3a\u5b58\u50a8\u8fc7\u7a0b\u8bed\u53e5\uff0c\u4e0d\u53ef\u4f7f\u7528\u975e\u5b58\u50a8\u8fc7\u7a0b\u7c7b\u578b\u6267\u884c", cause);
                throw new BizException(ResultCode.SYSTEM_ERROR, throwable);
            }
            throw new BizException(ResultCode.SYSTEM_ERROR, (Throwable)e);
        }
        finally {
            if (transactionCon == null) {
                try {
                    if (con != null) {
                        con.close();
                    }
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        return resultJson;
    }

    public Integer findTotalCount(DBQuery dbQuery) throws BizException {
        Integer totalCount;
        Statement ps = null;
        Connection con = null;
        ResultSet rs = null;
        try {
            con = this.manateeDataSource.getConnection(dbQuery.getDb());
            String databaseProductName = con.getMetaData().getDatabaseProductName().toLowerCase();
            dbQuery.setDatabaseProductName(databaseProductName);
            rs = this.getSelectTotalCount(dbQuery, con, (PreparedStatement)ps);
            rs.next();
            totalCount = rs.getInt(1);
        }
        catch (SQLException e) {
            throw new BizException(ResultCode.SYSTEM_ERROR, (Throwable)e);
        }
        finally {
            try {
                if (ps != null) {
                    ps.close();
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            try {
                if (con != null) {
                    con.close();
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        return totalCount;
    }

    public List<Map<String, Object>> findList(DBQuery dbQuery) throws BizException {
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        Statement ps = null;
        Connection con = null;
        ResultSet rs = null;
        try {
            con = this.manateeDataSource.getConnection(dbQuery.getDb());
            String databaseProductName = con.getMetaData().getDatabaseProductName().toLowerCase();
            dbQuery.setDatabaseProductName(databaseProductName);
            rs = this.getSelect(dbQuery, con, (PreparedStatement)ps);
            while (rs.next()) {
                Map<String, Object> aMap = this.convertMap(rs, dbQuery);
                list.add(aMap);
            }
        }
        catch (SQLException e) {
            throw new BizException(ResultCode.SYSTEM_ERROR, (Throwable)e);
        }
        finally {
            try {
                if (ps != null) {
                    ps.close();
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            try {
                if (con != null) {
                    con.close();
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        return list;
    }

    public JSON find(DBQuery dbQuery) throws BizException {
        List<Map<String, Object>> list = this.findList(dbQuery);
        if (dbQuery.getSelectOne().booleanValue()) {
            JSONObject jsonObject = list.size() > 0 ? new JSONObject(list.get(0)) : null;
            return jsonObject;
        }
        JSONArray dataArray = new JSONArray();
        dataArray.addAll(list);
        return dataArray;
    }

    public Integer findCount(DBQuery dbQuery) throws BizException {
        return this.findTotalCount(dbQuery);
    }

    public List<Map<String, Object>> findCascade(DBQuery dbQuery, JSON data, JSONObject cascadeConf) throws BizException {
        Statement ps = null;
        Connection con = null;
        ResultSet rs = null;
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        try {
            con = this.manateeDataSource.getConnection(dbQuery.getDb());
            String databaseProductName = con.getMetaData().getDatabaseProductName().toLowerCase();
            dbQuery.setDatabaseProductName(databaseProductName);
            rs = this.cascadeQuery(dbQuery, con, (PreparedStatement)ps, data, cascadeConf);
            while (rs.next()) {
                Map<String, Object> aMap = this.convertMap(rs, dbQuery);
                list.add(aMap);
            }
        }
        catch (SQLException e) {
            throw new BizException(ResultCode.SYSTEM_ERROR, (Throwable)e);
        }
        finally {
            try {
                if (ps != null) {
                    ps.close();
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            try {
                if (con != null) {
                    con.close();
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        return list;
    }

    public static void main(String[] args) {
        int anInt = DBReadUtil.getInt();
        System.out.println(anInt);
    }

    private static int getInt() {
        int i = 0;
        try {
            int n = i = 1;
            return n;
        }
        finally {
            i = 2;
        }
    }

    public String getName() {
        return "mysql";
    }
}

