/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.lowcode.util;

import com.alibaba.fastjson.JSONObject;
import com.manatee.common.util.FileUtil;
import com.manatee.lowcode.util.OutputUtil;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URLEncoder;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ManateeExportUtil {
    @Autowired
    private OutputUtil outputUtil;

    public void exprotToResponse(JSONObject data, HttpServletResponse response) {
        String url;
        String lowcodeTempExcelUrl = data.getString("lowcodeTempExcelUrl");
        String lowcodeTempFileUrl = data.getString("lowcodeTempFileUrl");
        String lowcodeFileUrl = data.getString("lowcodeFileUrl");
        boolean needDelete = true;
        if (lowcodeTempExcelUrl != null && !lowcodeTempExcelUrl.isEmpty()) {
            url = lowcodeTempExcelUrl;
        } else if (lowcodeTempFileUrl != null && !lowcodeTempFileUrl.isEmpty()) {
            url = lowcodeTempFileUrl;
        } else if (lowcodeFileUrl != null && !lowcodeFileUrl.isEmpty()) {
            url = lowcodeFileUrl;
            needDelete = false;
        } else {
            return;
        }
        File fileOutput = new File(url);
        try {
            response.reset();
            response.setContentType("multipart/form-data");
            String formFileName = URLEncoder.encode(fileOutput.getName(), "UTF-8");
            response.setHeader("Content-Disposition", "attachment; filename=" + formFileName);
            response.addHeader("Access-Control-Allow-Origin", "*");
            response.addHeader("Access-Control-Allow-Methods", "GET,POST,OPTIONS");
            FileInputStream fis = new FileInputStream(fileOutput);
            BufferedInputStream buff = new BufferedInputStream(fis);
            BufferedOutputStream out = new BufferedOutputStream((OutputStream)response.getOutputStream());
            byte[] car = new byte[1024];
            int l = 0;
            while ((long)l < fileOutput.length()) {
                int j = buff.read(car, 0, 1024);
                l += j;
                out.write(car, 0, j);
            }
            fis.close();
            buff.close();
            out.close();
            if (needDelete) {
                FileUtil.deleteFile((String)url);
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

