/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.lowcode.process;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.manatee.check.CheckConditionUtil;
import com.manatee.check.CheckUtil;
import com.manatee.check.ICheck;
import com.manatee.check.domain.CheckContent;
import com.manatee.common.domain.ResultCode;
import com.manatee.common.exception.BizException;
import com.manatee.common.util.NumberUtils;
import com.manatee.common.util.StringUtil;
import com.manatee.lowcode.iutil.IOutputUtil;
import com.manatee.lowcode.iutil.IVariableUtil;
import com.manatee.lowcode.util.InputUtil;
import com.manatee.lowcode.util.ProcessConfUtil;
import com.manatee.process.IProcess;
import com.manatee.process.domain.ProcessContent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service
public class ParamCheckProcess
implements IProcess {
    @Resource
    protected InputUtil inputUtil;
    @Resource
    protected IOutputUtil outputUtil;
    @Resource
    protected CheckUtil checkUtil;
    @Resource
    private IVariableUtil variableUtil;
    @Resource
    private ProcessConfUtil processConfUtil;

    public void process(ProcessContent content) throws BizException {
        this.processConfUtil.checkConf(content, new String[]{"check"});
        String paramsKey = this.variableUtil.calVarInConf(content, "paramsKey");
        Object paramsObj = this.inputUtil.getData(content, paramsKey);
        JSONArray checkJsonArr = content.getStepConf().getJSONArray("check");
        if (paramsObj != null && paramsObj instanceof List) {
            this.batchParamCheck(content, paramsObj, checkJsonArr);
        } else {
            this.singleParamCheck(content, checkJsonArr);
        }
    }

    public Boolean getThrowOuterExceptionFlag(ProcessContent content) {
        Boolean throwOuterExceptionFlag = false;
        Object throwOuterExceptionObj = content.getStepConf("throwOuterExceptionFlag");
        if (throwOuterExceptionObj != null) {
            throwOuterExceptionFlag = (Boolean)throwOuterExceptionObj;
        }
        return throwOuterExceptionFlag;
    }

    public void batchParamCheck(ProcessContent content, Object paramsObj, JSONArray checkJsonArr) throws BizException {
        CheckContent checkContent = this.initCheckContent(content);
        List paramsJsonArr = (List)paramsObj;
        ArrayList<Map> passCheckList = new ArrayList<Map>();
        ArrayList<Map> failCheckList = new ArrayList<Map>();
        int index = 0;
        for (Object o : paramsJsonArr) {
            Map paramsKeyValue = (Map)o;
            paramsKeyValue.put("index", index);
            checkContent.setParamsKeyValue(paramsKeyValue);
            this.paramCheckV2(checkContent, checkJsonArr, content, "batch");
            if (!checkContent.isSuccess()) {
                paramsKeyValue.put("failMsg", checkContent.getMsg());
                failCheckList.add(paramsKeyValue);
            } else {
                passCheckList.add(paramsKeyValue);
            }
            ++index;
        }
        JSONObject result = new JSONObject();
        result.put("passCheckList", passCheckList);
        result.put("failCheckList", failCheckList);
        this.outputUtil.unfoldPutData(content, (Map)result);
    }

    public void singleParamCheck(ProcessContent content, JSONArray checkJsonArr) throws BizException {
        Boolean throwOuterExceptionFlag = this.getThrowOuterExceptionFlag(content);
        CheckContent checkContent = this.initCheckContent(content);
        HashSet<String> paramNamesSet = new HashSet<String>();
        for (Object o : checkJsonArr) {
            String[] checkNameArr;
            JSONObject checkJson = new JSONObject((Map)o);
            JSONArray checkConditionArray = checkJson.getJSONArray("checkConditionArray");
            if (checkConditionArray != null && checkConditionArray.size() > 0) continue;
            String checkName = checkJson.getString("checkName");
            if (StringUtil.isBlank((String)checkName)) {
                throw new BizException(ResultCode.CONF_ERROR, "[\u53c2\u6570\u6821\u9a8c\u7ec4\u4ef6]\u5b57\u6bb5\u540d\u4e3a\u5fc5\u586b\u53c2\u6570\uff01");
            }
            for (String paramName : checkNameArr = checkName.split(",")) {
                paramNamesSet.add(paramName);
            }
        }
        HashMap<String, Object> paramsKeyValue = new HashMap<String, Object>();
        if (paramNamesSet.size() > 0) {
            for (String paramName : paramNamesSet) {
                paramsKeyValue.put(paramName, content.getValue(paramName));
            }
        }
        checkContent.setParamsKeyValue(paramsKeyValue);
        this.paramCheckV2(checkContent, checkJsonArr, content, "single");
        JSONObject checkJson = new JSONObject();
        checkJson.put("pass", (Object)true);
        checkJson.put("msg", (Object)"check success");
        if (!checkContent.isSuccess()) {
            checkJson.put("pass", (Object)false);
            checkJson.put("msg", (Object)checkContent.getMsg());
            if (throwOuterExceptionFlag.booleanValue()) {
                BizException bizException = this.getException(content, checkContent);
                throw bizException;
            }
            JSONObject checkResult = new JSONObject();
            checkResult.put("checkResult", (Object)checkJson);
            this.outputUtil.unfoldPutData(content, (Map)checkResult);
        }
    }

    public BizException getException(ProcessContent content, CheckContent checkContent) {
        BizException bizException = new BizException();
        bizException.setResultCode(ResultCode.PARAM_IS_ERROR);
        Object msgObj = content.getStepConf("resultMsg");
        bizException.setMsg(msgObj == null ? checkContent.getMsg() : msgObj.toString());
        String resultSubCode = content.getStepConf("resultSubCode") != null ? content.getStepConf("resultSubCode").toString() : "";
        bizException.setSubCode(resultSubCode);
        Integer interruptLevel = content.getStepConf("interruptLevel") != null ? (Integer)content.getStepConf("interruptLevel") : 3;
        bizException.setInterrupt(interruptLevel);
        bizException.setStepName(this.getName());
        String resultStatus = this.variableUtil.calVarInConf(content, "resultStatus");
        if (NumberUtils.isNumber((String)resultStatus)) {
            bizException.setResultStatus(Integer.valueOf(resultStatus));
        }
        bizException.putContent("id", (Object)content.getStep().getId());
        return bizException;
    }

    public void paramCheck(CheckContent checkContent, JSONArray checkJsonArr, ProcessContent content) {
        for (Object o : checkJsonArr) {
            JSONObject checkJson = new JSONObject((Map)o);
            String checkType = checkJson.getString("checkType");
            String checkName = checkJson.getString("checkName");
            String checkRule = checkJson.getString("checkRule");
            String resultMsg = this.getParamCheckValue(content, checkJson.getString("resultMsg"));
            ICheck check = this.checkUtil.getCheck(checkType);
            checkContent.setParams(checkName);
            checkContent.setExpression(checkRule);
            CheckContent checkContentTemp = new CheckContent(checkContent.getParamsKeyValue(), checkContent.getParams(), checkContent.getExpression(), true, checkContent.getMsg());
            if (checkContentTemp.getRequest() == null) {
                checkContentTemp.setRequest(checkContent.getParamsKeyValue());
            } else {
                checkContentTemp.getRequest().putAll(checkContent.getParamsKeyValue());
            }
            check.doCheck(checkContentTemp);
            checkContent.setSuccess(checkContentTemp.isSuccess());
            if (StringUtil.isNotBlank((String)resultMsg)) {
                checkContent.setMsg(resultMsg);
            } else {
                checkContent.setMsg(checkContentTemp.getMsg());
            }
            if (checkContent.isSuccess()) continue;
            break;
        }
    }

    public void paramCheckV2(CheckContent checkContent, JSONArray checkJsonArr, ProcessContent content, String type) {
        for (Object o : checkJsonArr) {
            String checkRule;
            String checkName;
            String checkType;
            JSONObject checkJson = new JSONObject((Map)o);
            JSONArray checkConditionArray = checkJson.getJSONArray("checkConditionArray");
            if (checkConditionArray != null && checkConditionArray.size() > 0) {
                JSONObject checkConditionJson = CheckConditionUtil.checkConditionPackage((JSONArray)checkConditionArray);
                checkType = "expression_v2";
                checkName = checkConditionJson.getString("checkName");
                checkRule = checkConditionJson.getString("checkCondition");
                if (checkContent.getParamsKeyValue() != null) {
                    if (StringUtils.equals((CharSequence)type, (CharSequence)"single")) {
                        checkContent.getParamsKeyValue().putAll(content.getRequest());
                    }
                } else {
                    checkContent.setParamsKeyValue(content.getRequest());
                }
            } else {
                checkType = checkJson.getString("checkType");
                checkName = checkJson.getString("checkName");
                checkRule = checkJson.getString("checkRule");
            }
            String resultMsg = this.getParamCheckValue(content, checkJson.getString("resultMsg"));
            ICheck check = this.checkUtil.getCheck(checkType);
            checkContent.setParams(checkName);
            checkContent.setExpression(checkRule);
            CheckContent checkContentTemp = new CheckContent(checkContent.getParamsKeyValue(), checkContent.getParams(), checkContent.getExpression(), true, checkContent.getMsg());
            if (checkContentTemp.getRequest() == null) {
                checkContentTemp.setRequest(checkContent.getParamsKeyValue());
            } else {
                checkContentTemp.getRequest().putAll(checkContent.getParamsKeyValue());
            }
            check.doCheck(checkContentTemp);
            checkContent.setSuccess(checkContentTemp.isSuccess());
            if (StringUtil.isNotBlank((String)resultMsg)) {
                checkContent.setMsg(resultMsg);
            } else {
                checkContent.setMsg(checkContentTemp.getMsg());
            }
            if (checkContent.isSuccess()) continue;
            break;
        }
    }

    private CheckContent initCheckContent(ProcessContent content) {
        CheckContent checkContent = new CheckContent();
        BeanUtils.copyProperties((Object)content, (Object)checkContent);
        checkContent.setRequest(content.getRequest());
        checkContent.setResponse(content.getResponse());
        checkContent.setTemp(content.getTemp());
        return checkContent;
    }

    private String getParamCheckValue(ProcessContent content, String key) {
        if (key == null) {
            return null;
        }
        if (key.startsWith("${") && key.endsWith("}")) {
            key = key.substring(2, key.length() - 1);
            if (content.getRequest().containsKey(key)) {
                return content.getRequest().get(key).toString();
            }
        } else {
            return key;
        }
        return null;
    }

    public String getName() {
        return "paramCheck";
    }
}

