/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.lowcode.manager;

import com.manatee.common.domain.ResultCode;
import com.manatee.common.exception.BizException;
import com.manatee.common.util.StringUtil;
import com.manatee.lowcode.util.VariableUtil;
import com.manatee.process.domain.ProcessContent;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Resource;
import org.springframework.stereotype.Component;

@Component
public class ResultMsgManager {
    @Resource
    private VariableUtil variableUtil;
    public static Map<String, String> subCodeMsg = new ConcurrentHashMap<String, String>();

    public String getMsg(ProcessContent content) {
        String msg = null;
        if (content.getRequest() != null && StringUtil.isNotBlank((String)(msg = (String)content.getRequestSubValue("outputMsg")))) {
            return msg;
        }
        BizException exception = content.getException();
        if (exception == null) {
            return ResultCode.SUCCESS.getMsg();
        }
        exception.setProcessCode(content.getCode());
        String aMsg = this.getMsg(exception);
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("step", exception.getStepName());
        param.put("process", exception.getProcessCode());
        param.put("confKey", exception.getConfKey());
        param.put("defaultParam", exception.getDefaultParam());
        msg = this.variableUtil.calVar(param, aMsg);
        return msg;
    }

    private String getMsg(BizException exception) {
        String msg = exception.getResultTrace().getMsg();
        String subCode = exception.getSubCode();
        if (StringUtil.isBlank((String)subCode)) {
            return msg;
        }
        String subCodeAppend = subCode + ":" + exception.getStepName();
        String aMsg = subCodeMsg.get(subCodeAppend);
        if (aMsg == null) {
            aMsg = subCodeMsg.get(subCode);
        }
        if (aMsg != null) {
            msg = aMsg;
        }
        return msg;
    }

    public static void main(String[] args) {
    }

    static {
        subCodeMsg.put("process_not_found", "\u6d41\u7a0b\u56fe\u3010${process}\u3011\u6ca1\u6709\u627e\u5230");
        subCodeMsg.put("process_not_publish", "\u6d41\u7a0b\u56fe\u3010${process}\u3011\u8fd8\u6ca1\u6709\u53d1\u5e03");
        subCodeMsg.put("step_missing_conf", "\u7ec4\u4ef6\u3010${step}\u3011\u7f3a\u5c11\u76f8\u5173\u914d\u7f6e");
        subCodeMsg.put("step_is_null", "\u7ec4\u4ef6\u3010${step}\u3011\u4e0d\u5b58\u5728");
        subCodeMsg.put("step_is_null:ifCondition", "if\u6761\u4ef6\u7ec4\u4ef6\u4e0d\u80fd\u5355\u72ec\u4f7f\u7528\uff0c\u8bf7\u7ed3\u5408if else\u7ec4\u4ef6\u4f7f\u7528");
        subCodeMsg.put("step_conf_is_null", "\u7ec4\u4ef6\u3010${step}\u3011\u914d\u7f6e\u4e0d\u5b58\u5728");
        subCodeMsg.put("step_conf_key_is_null", "\u7ec4\u4ef6\u3010${step}\u3011\u4e2d\u914d\u7f6e\u3010${confKey}\u3011\u4e0d\u5b58\u5728");
        subCodeMsg.put("function_not_define", "\u65b9\u6cd5\u3010${defaultParam}\u3011\u627e\u4e0d\u5230\uff0c\u8bf7\u786e\u8ba4\u540d\u79f0\u662f\u5426\u6b63\u786e");
        subCodeMsg.put("method_not_find", "\u672c\u5730\u65b9\u6cd5\u3010${defaultParam}\u3011\u627e\u4e0d\u5230\uff0c\u8bf7\u786e\u8ba4\u540d\u79f0\uff0c\u6216\u8005\u5165\u53c2\u662f\u5426\u6b63\u786e");
        subCodeMsg.put("params_error", "\u53c2\u6570\u683c\u5f0f\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\u53c2\u6570\uff1a${defaultParam}");
        subCodeMsg.put("module_is_null", "\u6a21\u5757\u3010${defaultParam}\u3011\u4e0d\u5b58\u5728\uff0c\u786e\u8ba4\u662f\u5426\u5df2\u53d1\u5e03\u6216\u8005\u5df2\u5220\u9664");
        subCodeMsg.put("circular_reference_code", "\u6a21\u5757\u3010${defaultParam}\u3011\u4e0d\u80fd\u5f15\u7528\u81ea\u5df1");
    }
}

