/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.camunda.process.task.handle;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.aliyun.oss.ServiceException;
import com.manatee.camunda.dto.TaskDTO;
import com.manatee.camunda.process.constants.BpmTaskStatusEnum;
import com.manatee.camunda.process.service.ManateeTaskService;
import com.manatee.camunda.process.task.handle.ProcessAllWay;
import com.manatee.camunda.process.task.handle.TaskHandle;
import com.manatee.common.exception.BizException;
import com.manatee.common.util.tool.core.collection.CollUtil;
import com.manatee.common.util.tool.core.util.IdUtil;
import com.manatee.process.domain.ProcessContent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.camunda.bpm.engine.HistoryService;
import org.camunda.bpm.engine.RepositoryService;
import org.camunda.bpm.engine.RuntimeService;
import org.camunda.bpm.engine.TaskService;
import org.camunda.bpm.engine.history.HistoricTaskInstance;
import org.camunda.bpm.engine.history.HistoricTaskInstanceQuery;
import org.camunda.bpm.engine.history.HistoricVariableInstance;
import org.camunda.bpm.engine.impl.persistence.entity.ExecutionEntity;
import org.camunda.bpm.engine.impl.persistence.entity.TaskEntity;
import org.camunda.bpm.engine.runtime.Execution;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.runtime.ProcessInstanceModificationBuilder;
import org.camunda.bpm.engine.runtime.ProcessInstanceModificationInstantiationBuilder;
import org.camunda.bpm.engine.runtime.VariableInstance;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.camunda.bpm.model.bpmn.Query;
import org.camunda.bpm.model.bpmn.instance.BaseElement;
import org.camunda.bpm.model.bpmn.instance.ExtensionElements;
import org.camunda.bpm.model.bpmn.instance.FlowNode;
import org.camunda.bpm.model.bpmn.instance.MultiInstanceLoopCharacteristics;
import org.camunda.bpm.model.bpmn.instance.SequenceFlow;
import org.camunda.bpm.model.bpmn.instance.StartEvent;
import org.camunda.bpm.model.bpmn.instance.UserTask;
import org.camunda.bpm.model.bpmn.instance.camunda.CamundaProperties;
import org.camunda.bpm.model.bpmn.instance.camunda.CamundaProperty;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class BackToPreviousNodeTaskHandle
implements TaskHandle {
    private Logger log = LoggerFactory.getLogger(BackToPreviousNodeTaskHandle.class);
    @Resource
    private RuntimeService runtimeService;
    @Resource
    private TaskService taskService;
    @Resource
    private HistoryService historyService;
    @Autowired
    private ManateeTaskService manateeTaskService;
    @Autowired
    private RepositoryService repositoryService;

    @Override
    public JSONObject handle(TaskDTO taskDTO) throws BizException {
        String taskId = taskDTO.getTaskId();
        String processId = taskDTO.getProcessInstanceId();
        String msg = taskDTO.getMessage();
        ProcessInstance processInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processInstanceId(processId).singleResult();
        if (processInstance == null) {
            throw new ServiceException("\u6d41\u7a0b\u5b9e\u4f8b\u5f02\u5e38");
        }
        if (this.historyService.createHistoricTaskInstanceQuery().processInstanceId(processId).finished().list().size() <= 0) {
            throw new ServiceException("\u6d41\u7a0b\u672a\u88ab\u5904\u7406\u8fc7\uff0c\u65e0\u6cd5\u9000\u56de\u8282\u70b9");
        }
        Task currentTask = (Task)this.taskService.createTaskQuery().processInstanceId(processId).taskId(taskId).singleResult();
        if (currentTask == null) {
            throw new ServiceException("\u5df2\u88ab\u5904\u7406\u7684\u4efb\u52a1\uff0c\u65e0\u6cd5\u9000\u56de\u8282\u70b9");
        }
        int nodeType = this.checkNodeType_(processId, currentTask);
        if (nodeType == 1 || nodeType == 2 || nodeType == 3) {
            JSONObject r = this.addSignerBack(processId, currentTask, nodeType);
            if (r != null) {
                return r;
            }
            if (nodeType == 1 || nodeType == 3) {
                Task cTask = (Task)this.taskService.createTaskQuery().taskId(taskId).singleResult();
                Task task2 = (Task)this.taskService.createTaskQuery().taskId(cTask.getParentTaskId()).singleResult();
                List subTaskList = this.taskService.createTaskQuery().processInstanceId(processId).taskParentTaskId(cTask.getParentTaskId()).active().list();
                if (subTaskList.size() > 0) {
                    ArrayList cancelTaskList = new ArrayList();
                    String finalProcessInstanceId1 = processId;
                    subTaskList.forEach(subTask -> {
                        this.taskService.deleteTask(subTask.getId(), "\u9000\u56de\u4e0a\u4e00\u6b65");
                        HashMap<String, String> c = new HashMap<String, String>();
                        c.put("taskId", subTask.getId());
                        c.put("taskDefKey", subTask.getTaskDefinitionKey());
                        c.put("taskName", subTask.getName());
                        c.put("assignee", subTask.getAssignee());
                        c.put("processId", finalProcessInstanceId1);
                        cancelTaskList.add(c);
                    });
                    Execution execution = (Execution)this.runtimeService.createExecutionQuery().executionId(task2.getExecutionId()).singleResult();
                    ((ProcessInstanceModificationInstantiationBuilder)this.runtimeService.createProcessInstanceModification(processId).startBeforeActivity(task2.getTaskDefinitionKey())).execute();
                    this.taskService.createComment(taskId, processId, "return@@:\u53d6\u56de");
                    this.runtimeService.createProcessInstanceModification(processId).cancelActivityInstance(((ExecutionEntity)execution).getActivityInstanceId()).execute();
                    HashMap<String, String> c = new HashMap<String, String>();
                    c.put("taskId", task2.getId());
                    c.put("taskDefKey", task2.getTaskDefinitionKey());
                    c.put("taskName", task2.getName());
                    c.put("assignee", task2.getAssignee());
                    c.put("processId", processId);
                    cancelTaskList.add(c);
                    r = new JSONObject();
                    r.put("cancelTask", cancelTaskList);
                    r.put("processId", (Object)processId);
                    return r;
                }
            }
        }
        ArrayList cancelTaskList = new ArrayList();
        ArrayList createTaskList = new ArrayList();
        BpmnModelInstance bpmnModelInstance = this.repositoryService.getBpmnModelInstance(processInstance.getProcessDefinitionId());
        UserTask userTask = (UserTask)bpmnModelInstance.getModelElementById(currentTask.getTaskDefinitionKey());
        List<FlowNode> allNode = this.filterNode(userTask, bpmnModelInstance);
        if (allNode.size() <= 0) {
            throw new ServiceException("\u9000\u56de\u4e0a\u4e00\u6b65\u5f02\u5e38");
        }
        ProcessInstanceModificationBuilder builder = this.runtimeService.createProcessInstanceModification(processId);
        AtomicBoolean isParallelGateway = new AtomicBoolean(false);
        allNode.forEach(node -> {
            FlowNode n = this.manateeTaskService.getNextParallelGateway((FlowNode)node);
            if (n != null) {
                isParallelGateway.set(true);
            }
            this.startBeforeActivity(builder, (FlowNode)node);
        });
        List actTaskList = new ArrayList();
        actTaskList = isParallelGateway.get() ? this.taskService.createTaskQuery().processInstanceId(processId).active().list() : this.taskService.createTaskQuery().processInstanceId(processId).taskDefinitionKey(currentTask.getTaskDefinitionKey()).active().list();
        builder.execute();
        ProcessInstanceModificationBuilder pBuilder = this.runtimeService.createProcessInstanceModification(processId);
        actTaskList.forEach(task -> {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("taskId", (Object)task.getId());
            jsonObject.put("taskDefKey", (Object)task.getTaskDefinitionKey());
            jsonObject.put("taskName", (Object)task.getName());
            jsonObject.put("assignee", (Object)task.getAssignee());
            jsonObject.put("processId", (Object)processId);
            cancelTaskList.add(jsonObject);
            this.taskService.createComment(task.getId(), processId, "return@@:" + msg);
            pBuilder.cancelAllForActivity(this.manateeTaskService.getActivityId(task.getTaskDefinitionKey()));
        });
        pBuilder.execute();
        ArrayList newSubTaskInfos = new ArrayList();
        List openedTaskList = this.taskService.createTaskQuery().processInstanceId(processId).active().list();
        openedTaskList.forEach(task -> {
            JSONObject subTaskInfo = this.addSignerBackBeforeMaterial(processId, taskId, (Task)task);
            if (subTaskInfo == null) {
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("taskId", (Object)task.getId());
                jsonObject.put("taskDefinitionKey", (Object)task.getTaskDefinitionKey());
                jsonObject.put("processDefinitionId", (Object)processInstance.getProcessDefinitionId());
                jsonObject.put("processId", (Object)processId);
                jsonObject.put("taskName", (Object)task.getName());
                jsonObject.put("assignee", (Object)task.getAssignee());
                createTaskList.add(jsonObject);
            } else {
                newSubTaskInfos.add(subTaskInfo);
            }
        });
        String firstTaskKey = allNode.stream().map(BaseElement::getId).collect(Collectors.joining(","));
        this.runtimeService.setVariable(processId, "MANATEE_BACK_FIRSTTASKID", (Object)firstTaskKey);
        HashSet lastTaskDef = new HashSet();
        actTaskList.forEach(t -> lastTaskDef.add(this.manateeTaskService.getActivityId(t.getTaskDefinitionKey())));
        String lastTaskDefKey = String.join((CharSequence)",", lastTaskDef);
        this.runtimeService.setVariable(processId, "MANATEE_BACK_LATESTTASKID", (Object)lastTaskDefKey);
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("cancelTask", cancelTaskList);
        jsonObject.put("createTask", createTaskList);
        jsonObject.put("processId", (Object)processId);
        jsonObject.put("newSubTaskInfos", newSubTaskInfos);
        this.log.debug("BackToPreviousNodeTaskHandle backBeforeMaterial:{}", (Object)jsonObject.toJSONString());
        return jsonObject;
    }

    @Override
    public TaskDTO build(TaskDTO taskDTO, ProcessContent content) {
        return taskDTO;
    }

    public int checkNodeType_(String processId, Task currentTask) {
        String taskKey = this.manateeTaskService.getActivityId(currentTask.getTaskDefinitionKey());
        VariableInstance strategyVariableInstance = (VariableInstance)this.runtimeService.createVariableInstanceQuery().processInstanceIdIn(new String[]{processId}).variableName("MANATEE_TASK_ADD_SIGNER_STRATEGY:" + taskKey).singleResult();
        if (strategyVariableInstance == null) {
            return 0;
        }
        boolean isInnerNode = currentTask.getTaskDefinitionKey().contains("#addSigner:");
        String singerType = "";
        Task pTask = null;
        pTask = isInnerNode ? (Task)this.taskService.createTaskQuery().processInstanceId(processId).taskDefinitionKey(taskKey).taskId(currentTask.getParentTaskId()).singleResult() : currentTask;
        JSONArray taskAddSignerHisNodeInfos = new JSONArray();
        if (pTask == null) {
            HistoricTaskInstance historicTaskInstance = (HistoricTaskInstance)this.historyService.createHistoricTaskInstanceQuery().processInstanceId(processId).taskDefinitionKey(taskKey).list().get(0);
            HistoricVariableInstance historicVariableInstance = (HistoricVariableInstance)this.historyService.createHistoricVariableInstanceQuery().processInstanceId(processId).variableName("MANATEE_TASK_ADD_SIGNER_HIS_NODE_INFO").activityInstanceIdIn(new String[]{historicTaskInstance.getActivityInstanceId()}).list().get(0);
            String taskAddSignerHisNodeInfoStr = historicVariableInstance.getValue().toString();
            taskAddSignerHisNodeInfos = JSON.parseArray((String)taskAddSignerHisNodeInfoStr);
        } else {
            taskAddSignerHisNodeInfos = JSONObject.parseArray((String)((String)this.taskService.getVariableLocal(pTask.getId(), "MANATEE_TASK_ADD_SIGNER_HIS_NODE_INFO")));
        }
        for (int i = 0; i < taskAddSignerHisNodeInfos.size(); ++i) {
            JSONObject taskAddSignerHisNodeInfo = (JSONObject)taskAddSignerHisNodeInfos.get(i);
            singerType = taskAddSignerHisNodeInfo.getString("addSignerType");
        }
        if (singerType.equals("after")) {
            return isInnerNode ? 3 : 4;
        }
        return isInnerNode ? 1 : 2;
    }

    public JSONObject addSignerBack(String processId, Task currentTask, int nodeType) {
        String taskKey = this.manateeTaskService.getActivityId(currentTask.getTaskDefinitionKey());
        VariableInstance strategyVariableInstance = (VariableInstance)this.runtimeService.createVariableInstanceQuery().processInstanceIdIn(new String[]{processId}).variableName("MANATEE_TASK_ADD_SIGNER_STRATEGY:" + taskKey).singleResult();
        String addSignerType = "";
        Task pTask = null;
        pTask = nodeType == 1 || nodeType == 3 ? (Task)this.taskService.createTaskQuery().processInstanceId(processId).taskDefinitionKey(taskKey).taskId(currentTask.getParentTaskId()).singleResult() : currentTask;
        JSONArray taskAddSignerHisNodeInfos = JSONObject.parseArray((String)((String)this.taskService.getVariableLocal(pTask.getId(), "MANATEE_TASK_ADD_SIGNER_HIS_NODE_INFO")));
        for (int i = 0; i < taskAddSignerHisNodeInfos.size(); ++i) {
            JSONObject taskAddSignerNodeInfo = (JSONObject)taskAddSignerHisNodeInfos.get(i);
            addSignerType = taskAddSignerNodeInfo.getString("addSignerType");
        }
        JSONArray strategyList = (JSONArray)strategyVariableInstance.getValue();
        List<JSONObject> taskNodeList = this.getAddSignerNodeInfos((List)taskAddSignerHisNodeInfos, addSignerType);
        if (nodeType == 1 || nodeType == 3) {
            JSONObject taskAddSignerNodeInfo;
            int i;
            int index = 0;
            for (int i2 = 0; i2 < taskNodeList.size(); ++i2) {
                JSONObject taskAddSignerNodeInfo2 = taskNodeList.get(i2);
                String taskDefKey_ = taskAddSignerNodeInfo2.getString("taskDefKey");
                if (!taskDefKey_.equals(currentTask.getTaskDefinitionKey())) continue;
                index = i2;
            }
            Object preNode = null;
            ArrayList<JSONObject> preNodeList = new ArrayList<JSONObject>();
            if (addSignerType.equals("after")) {
                if (index == 0) {
                    if (nodeType == 3) {
                        return null;
                    }
                    throw new ServiceException("\u6700\u521d\u52a0\u7b7e\u8282\u70b9\uff0c\u65e0\u6cd5\u9000\u56de\u8282\u70b9");
                }
                for (i = index - 1; i < taskNodeList.size(); ++i) {
                    taskAddSignerNodeInfo = taskNodeList.get(i);
                    preNodeList.add(taskAddSignerNodeInfo);
                }
            } else {
                if (index == 0) {
                    if (nodeType == 1) {
                        return null;
                    }
                    throw new ServiceException("\u6700\u521d\u52a0\u7b7e\u8282\u70b9\uff0c\u65e0\u6cd5\u9000\u56de\u8282\u70b9");
                }
                for (i = index - 1; i < taskNodeList.size(); ++i) {
                    taskAddSignerNodeInfo = taskNodeList.get(i);
                    preNodeList.add(taskAddSignerNodeInfo);
                }
            }
            List cancelTask = this.taskService.createTaskQuery().processInstanceId(processId).taskParentTaskId(pTask.getId()).list();
            ArrayList addSignerCancelTaskIds = new ArrayList();
            cancelTask.forEach(task -> {
                this.taskService.createComment(task.getId(), processId, "return@@:\u9000\u56de\u4e0a\u4e00\u6b65");
                this.taskService.deleteTask(task.getId(), "\u9000\u56de\u4e0a\u4e00\u6b65");
                addSignerCancelTaskIds.add(task.getId());
            });
            JSONArray newSubTaskInfos = this.addSignerBackBeforeMaterial(processId, pTask, strategyList, (List)taskAddSignerHisNodeInfos, preNodeList);
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("addSignerCancelTaskIds", addSignerCancelTaskIds);
            jsonObject.put("newSubTaskInfos", (Object)newSubTaskInfos);
            jsonObject.put("processId", (Object)processId);
            return jsonObject;
        }
        JSONArray subTaskInfos = new JSONArray();
        JSONObject strategy = strategyList.getJSONObject(strategyList.size() - 1);
        JSONObject taskAddSignerHisNodeInfo = (JSONObject)taskAddSignerHisNodeInfos.get(taskAddSignerHisNodeInfos.size() - 1);
        subTaskInfos.add((Object)this.addSignerBackBeforeMaterial(processId, pTask, taskAddSignerHisNodeInfo, strategy));
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("newSubTaskInfos", (Object)subTaskInfos);
        jsonObject.put("processId", (Object)processId);
        this.log.debug("backBeforeMaterial:{}", (Object)jsonObject.toJSONString());
        return jsonObject;
    }

    public List<JSONObject> getAddSignerNodeInfos(List taskAddSignerHisNodeInfos, String addSignerType) {
        LinkedList<JSONObject> r = new LinkedList<JSONObject>();
        for (Object taskAddSignerNodeObj : taskAddSignerHisNodeInfos) {
            JSONObject taskAddSignerNodeInfo = (JSONObject)taskAddSignerNodeObj;
            String taskDefKey_ = taskAddSignerNodeInfo.getString("taskDefKey");
            String type = taskAddSignerNodeInfo.getString("addSignerType");
            if (!type.equals(addSignerType)) continue;
            r.add(taskAddSignerNodeInfo);
        }
        return r;
    }

    public JSONArray addSignerBackBeforeMaterial(String processId, Task pTask, JSONArray strategyList, List taskAddSignerHisNodeInfos, List<JSONObject> preNodeList) {
        this.taskService.setVariableLocal(pTask.getId(), "MANATEE_TASK_ADD_SIGNER_NODE_INFO", null);
        JSONArray subTaskInfos = new JSONArray();
        for (JSONObject preNode : preNodeList) {
            JSONObject strategy = strategyList.getJSONObject(taskAddSignerHisNodeInfos.indexOf(preNode));
            subTaskInfos.add((Object)this.addSignerBackBeforeMaterial(processId, pTask, preNode, strategy));
        }
        return subTaskInfos;
    }

    public JSONObject addSignerBackBeforeMaterial(String processId, Task pTask, JSONObject taskAddSignerHisNodeInfo, JSONObject strategy) {
        String addSignerType = taskAddSignerHisNodeInfo.getString("addSignerType");
        String processorType = taskAddSignerHisNodeInfo.getString("processorType");
        String approvedUserNo = "";
        if (strategy.containsKey((Object)"approvedUserNo")) {
            approvedUserNo = strategy.getString("approvedUserNo");
        }
        String approvedRoleCode = "";
        if (strategy.containsKey((Object)"approvedRoleCode")) {
            approvedRoleCode = strategy.getString("approvedRoleCode");
        }
        String taskDefKey = taskAddSignerHisNodeInfo.getString("taskDefKey");
        String nodeName = taskAddSignerHisNodeInfo.getString("nodeName");
        JSONArray subTaskInfos = taskAddSignerHisNodeInfo.getJSONArray("subTaskInfos");
        ArrayList<JSONObject> newSubTaskInfos = new ArrayList<JSONObject>();
        for (Object subTaskInfo : subTaskInfos) {
            JSONObject taskInfo = (JSONObject)subTaskInfo;
            TaskEntity newTaskEntity = (TaskEntity)this.taskService.newTask(IdUtil.fastSimpleUUID());
            newTaskEntity.setProcessInstanceId(processId);
            if (StringUtils.equals((CharSequence)processorType, (CharSequence)"user")) {
                newTaskEntity.setAssignee(taskInfo.getString("taskAssignee"));
            }
            newTaskEntity.setName(nodeName);
            newTaskEntity.setParentTaskId(pTask.getId());
            newTaskEntity.setDescription("@@addSigner:" + nodeName);
            newTaskEntity.setDueDate(pTask.getDueDate());
            newTaskEntity.setCaseExecutionId(pTask.getCaseExecutionId());
            newTaskEntity.setPriority(pTask.getPriority());
            newTaskEntity.setProcessDefinitionId(pTask.getProcessDefinitionId());
            newTaskEntity.setTaskDefinitionKey(taskDefKey);
            this.taskService.saveTask((Task)newTaskEntity);
            this.taskService.setVariableLocal(newTaskEntity.getId(), "ADD_SIGNER_TYPE", (Object)addSignerType);
            this.taskService.setVariableLocal(newTaskEntity.getId(), "PROCESSOR_TYPE", (Object)processorType);
            JSONObject subTask = new JSONObject();
            subTask.put("taskId", (Object)newTaskEntity.getId());
            subTask.put("status", (Object)BpmTaskStatusEnum.WAIT.getStatus());
            subTask.put("addSignerType", (Object)addSignerType);
            subTask.put("processorType", (Object)processorType);
            subTask.put("approvedUserNo", (Object)approvedUserNo);
            subTask.put("approvedRoleCode", (Object)approvedRoleCode);
            subTask.put("nodeName", (Object)nodeName);
            subTask.put("taskDefinitionKey", (Object)newTaskEntity.getTaskDefinitionKey());
            if (StringUtils.equals((CharSequence)processorType, (CharSequence)"user")) {
                subTask.put("taskAssignee", (Object)taskInfo.getString("taskAssignee"));
            }
            newSubTaskInfos.add(subTask);
        }
        JSONObject subTaskInfo = new JSONObject();
        subTaskInfo.put("nodeName", (Object)nodeName);
        subTaskInfo.put("subTaskInfos", newSubTaskInfos);
        subTaskInfo.put("taskDefKey", (Object)taskDefKey);
        subTaskInfo.put("addSignerType", (Object)addSignerType);
        subTaskInfo.put("processorType", (Object)processorType);
        subTaskInfo.put("pTaskId", (Object)pTask.getId());
        subTaskInfo.put("strategy", (Object)strategy);
        subTaskInfo.put("status", (Object)BpmTaskStatusEnum.WAIT.getStatus());
        this.taskService.setVariableLocal(pTask.getId(), "MANATEE_TASK_ADD_SIGNER_STATUS", (Object)BpmTaskStatusEnum.WAIT.getStatus());
        Object taskAddSignerNodeInfo = JSONObject.parseArray((String)((String)this.taskService.getVariableLocal(pTask.getId(), "MANATEE_TASK_ADD_SIGNER_NODE_INFO")));
        if (taskAddSignerNodeInfo == null) {
            taskAddSignerNodeInfo = new ArrayList();
        } else {
            taskAddSignerNodeInfo.add(subTaskInfo);
        }
        this.taskService.setVariableLocal(pTask.getId(), "MANATEE_TASK_ADD_SIGNER_NODE_INFO", (Object)JSONObject.toJSONString((Object)taskAddSignerNodeInfo));
        return subTaskInfo;
    }

    public JSONObject addSignerBackBeforeMaterial(String processId, String taskId, Task newTask) {
        List historicTaskInstances = ((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().processInstanceId(processId).taskDefinitionKey(newTask.getTaskDefinitionKey()).finished().orderByHistoricActivityInstanceStartTime().desc()).list();
        if (historicTaskInstances.size() <= 0) {
            return null;
        }
        HistoricTaskInstance historicTaskInstance = (HistoricTaskInstance)historicTaskInstances.get(0);
        if (historicTaskInstance != null) {
            HistoricVariableInstance historicVariableInstance = (HistoricVariableInstance)this.historyService.createHistoricVariableInstanceQuery().processInstanceId(processId).variableName("MANATEE_TASK_ADD_SIGNER_HIS_NODE_INFO").activityInstanceIdIn(new String[]{historicTaskInstance.getActivityInstanceId()}).singleResult();
            HistoricVariableInstance strategyVariableInstance = (HistoricVariableInstance)this.historyService.createHistoricVariableInstanceQuery().processInstanceId(processId).variableName("MANATEE_TASK_ADD_SIGNER_STRATEGY:" + newTask.getTaskDefinitionKey()).singleResult();
            if (historicVariableInstance != null) {
                HistoricVariableInstance addSignerTypeVariableInstance = (HistoricVariableInstance)this.historyService.createHistoricVariableInstanceQuery().processInstanceId(processId).variableName("ADD_SIGNER_TYPE").activityInstanceIdIn(new String[]{historicTaskInstance.getActivityInstanceId()}).singleResult();
                HistoricVariableInstance processorTypeVariableInstance = (HistoricVariableInstance)this.historyService.createHistoricVariableInstanceQuery().processInstanceId(processId).variableName("PROCESSOR_TYPE").activityInstanceIdIn(new String[]{historicTaskInstance.getActivityInstanceId()}).singleResult();
                String taskAddSignerHisNodeInfoStr = historicVariableInstance.getValue().toString();
                JSONArray taskAddSignerHisNodeInfos = JSON.parseArray((String)taskAddSignerHisNodeInfoStr);
                JSONArray strategyList = (JSONArray)strategyVariableInstance.getValue();
                JSONObject strategy = strategyList.getJSONObject(strategyList.size() - 1);
                JSONObject taskAddSignerHisNodeInfo = taskAddSignerHisNodeInfos.getJSONObject(taskAddSignerHisNodeInfos.size() - 1);
                String addSignerType = taskAddSignerHisNodeInfo.getString("addSignerType");
                String processorType = taskAddSignerHisNodeInfo.getString("processorType");
                this.taskService.setVariableLocal(newTask.getId(), "MANATEE_TASK_ADD_SIGNER_HIS_NODE_INFO", (Object)taskAddSignerHisNodeInfoStr);
                if (addSignerType.equals("after")) {
                    return this.addSignerBackBeforeMaterial(processId, newTask, taskAddSignerHisNodeInfo, strategy);
                }
            }
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public List<FlowNode> filterNode(UserTask userTask, BpmnModelInstance bpmnModelInstance) throws ServiceException {
        void var13_16;
        ArrayList<FlowNode> allNode = new ArrayList<FlowNode>();
        this.selectInAllNode((FlowNode)userTask, allNode, false, true);
        if (allNode.size() <= 0) {
            throw new ServiceException("\u9000\u56de\u4e0a\u4e00\u6b65\u5f02\u5e38");
        }
        Collection startEvents = bpmnModelInstance.getModelElementsByType(StartEvent.class);
        StartEvent startEvent = (StartEvent)startEvents.iterator().next();
        ProcessAllWay backBeforeGateWay = new ProcessAllWay((FlowNode)startEvent);
        ProcessAllWay.Gateway gateway_ = new ProcessAllWay.Gateway(backBeforeGateWay.getBaseNode());
        backBeforeGateWay.getGatewayList().add(gateway_);
        this.selectInAllWay((FlowNode)userTask, backBeforeGateWay, gateway_);
        if (backBeforeGateWay.getGatewayList().size() <= 1) {
            return allNode;
        }
        String[] keys = allNode.stream().map(flowNode -> flowNode.getId()).collect(Collectors.toList()).toArray(new String[0]);
        List historicTaskInstanceList = ((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().taskDefinitionKeyIn(keys).orderByHistoricActivityInstanceStartTime().desc()).finished().list();
        if (historicTaskInstanceList.size() <= 0) {
            return allNode;
        }
        HistoricTaskInstance historicTaskInstance = (HistoricTaskInstance)historicTaskInstanceList.get(0);
        FlowNode f_ = null;
        for (FlowNode flowNode2 : allNode) {
            if (!flowNode2.getId().equals(this.manateeTaskService.getActivityId(historicTaskInstance.getTaskDefinitionKey()))) continue;
            f_ = flowNode2;
        }
        ArrayList<FlowNode> exNodes = new ArrayList<FlowNode>();
        for (FlowNode f : allNode) {
            if (f.getId().equals(this.manateeTaskService.getActivityId(historicTaskInstance.getTaskDefinitionKey()))) {
                f_ = f;
                continue;
            }
            ArrayList<FlowNode> allNode_ = new ArrayList<FlowNode>();
            this.selectInAllNode(f, allNode_, true);
            if (!allNode_.contains(f_)) continue;
            exNodes.add(f);
        }
        Object var13_15 = null;
        for (ProcessAllWay.Gateway gw : backBeforeGateWay.getGatewayList()) {
            if (!gw.getOtherWayList().contains(f_)) continue;
            ProcessAllWay.Gateway gateway = gw;
        }
        if (var13_16 == null || var13_16.getOtherWayList().size() <= 0) {
            return allNode;
        }
        return var13_16.getOtherWayList();
    }

    public void selectInAllNode(FlowNode element, List<FlowNode> allNode, boolean isAll, boolean isSkipReviewed) {
        Collection sequenceFlow = element.getIncoming();
        Iterator entries = sequenceFlow.iterator();
        ArrayList<FlowNode> node = new ArrayList<FlowNode>();
        while (entries.hasNext()) {
            SequenceFlow flow = (SequenceFlow)entries.next();
            FlowNode element1 = flow.getSource();
            node.add(element1);
        }
        for (FlowNode flowElement : node) {
            if (allNode.contains(flowElement)) continue;
            if (Objects.equals(flowElement.getElementType().getTypeName(), "exclusiveGateway")) {
                this.selectInAllNode(flowElement, allNode, isAll, isSkipReviewed);
                continue;
            }
            if (Objects.equals(flowElement.getElementType().getTypeName(), "parallelGateway")) {
                this.selectInAllNode(flowElement, allNode, isAll, isSkipReviewed);
                continue;
            }
            if (isSkipReviewed) {
                if (this.getNodeType(flowElement) == 2) {
                    this.selectInAllNode(flowElement, allNode, isAll, true);
                    continue;
                }
                allNode.add(flowElement);
                if (!isAll) continue;
                this.selectInAllNode(flowElement, allNode, true, isSkipReviewed);
                continue;
            }
            allNode.add(flowElement);
            if (!isAll) continue;
            this.selectInAllNode(flowElement, allNode, true, isSkipReviewed);
        }
    }

    public JSONArray selectInAllNode(String processId, String taskId, boolean isAll) throws ServiceException {
        ArrayList<FlowNode> allNode = new ArrayList<FlowNode>();
        Task task = (Task)this.taskService.createTaskQuery().processInstanceId(processId).taskId(taskId).singleResult();
        String defKey = this.manateeTaskService.getActivityId(task.getTaskDefinitionKey());
        BpmnModelInstance bpmnModelInstance = this.repositoryService.getBpmnModelInstance(task.getProcessDefinitionId());
        FlowNode flowNode = (FlowNode)bpmnModelInstance.getModelElementById(defKey);
        this.selectInAllNode_(flowNode, allNode, isAll, true);
        JSONArray inNodes = new JSONArray();
        allNode.forEach(node -> {
            if (Objects.equals(node.getElementType().getTypeName(), "userTask")) {
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("taskDefKey", (Object)node.getId());
                jsonObject.put("taskName", (Object)node.getName());
                inNodes.add((Object)jsonObject);
            }
        });
        return inNodes;
    }

    public void selectInAllNode(FlowNode element, List<FlowNode> allNode, boolean isAll) {
        this.selectInAllNode(element, allNode, isAll, false);
    }

    public void selectInAllNode_(FlowNode element, List<FlowNode> allNode, boolean isAll, boolean isSkipReviewed) {
        Collection sequenceFlow = element.getIncoming();
        Iterator entries = sequenceFlow.iterator();
        ArrayList<FlowNode> node = new ArrayList<FlowNode>();
        while (entries.hasNext()) {
            SequenceFlow flow = (SequenceFlow)entries.next();
            FlowNode element1 = flow.getSource();
            node.add(element1);
        }
        for (FlowNode flowElement : node) {
            if (Objects.equals(flowElement.getElementType().getTypeName(), "exclusiveGateway")) {
                this.selectInAllNode_(flowElement, allNode, isAll, isSkipReviewed);
                continue;
            }
            if (Objects.equals(flowElement.getElementType().getTypeName(), "parallelGateway")) {
                this.selectInAllNode_(flowElement, allNode, isAll, isSkipReviewed);
                continue;
            }
            if (isSkipReviewed) {
                if (this.getNodeType(flowElement) == 2) {
                    this.selectInAllNode_(flowElement, allNode, isAll, true);
                    continue;
                }
                if (allNode.contains(flowElement)) {
                    allNode.remove(flowElement);
                }
                allNode.add(flowElement);
                if (!isAll) continue;
                this.selectInAllNode_(flowElement, allNode, true, isSkipReviewed);
                continue;
            }
            if (allNode.contains(flowElement)) {
                allNode.remove(flowElement);
            }
            allNode.add(flowElement);
            if (!isAll) continue;
            this.selectInAllNode_(flowElement, allNode, true, isSkipReviewed);
        }
    }

    public int getNodeType(FlowNode element) {
        JSONObject result = this.getNodeProperties(element);
        int nodeType = 1;
        if (result.containsKey((Object)"actions")) {
            String[] actionsArr;
            String actions = result.getString("actions");
            for (String action : actionsArr = actions.split(";")) {
                String v = action.split(":")[0];
                if (v.equals("reviewed")) {
                    nodeType = 2;
                    continue;
                }
                if (!v.equals("vote")) continue;
                nodeType = 3;
            }
        }
        if (result.containsKey((Object)"nodeType")) {
            nodeType = result.getIntValue("nodeType");
        }
        return nodeType;
    }

    public JSONObject getNodeProperties(FlowNode element) {
        Collection camundaProperties;
        Query elementsQuery;
        JSONObject result = new JSONObject();
        ExtensionElements extensionElements = element.getExtensionElements();
        if (extensionElements != null && (elementsQuery = extensionElements.getElementsQuery()) != null && CollUtil.isNotEmpty((Collection)(camundaProperties = ((CamundaProperties)elementsQuery.filterByType(CamundaProperties.class).singleResult()).getCamundaProperties()))) {
            for (CamundaProperty camundaProperty : camundaProperties) {
                result.put(camundaProperty.getCamundaName(), (Object)camundaProperty.getCamundaValue());
            }
        }
        return result;
    }

    public void selectInAllWay(FlowNode element, ProcessAllWay processAllWay, ProcessAllWay.Gateway gateway1) {
        int i;
        boolean isExclusive = false;
        if (Objects.equals(element.getElementType().getTypeName(), "exclusiveGateway")) {
            isExclusive = true;
        }
        Collection sequenceFlow = element.getIncoming();
        Iterator entries = sequenceFlow.iterator();
        ArrayList<FlowNode> node = new ArrayList<FlowNode>();
        while (entries.hasNext()) {
            SequenceFlow flow = (SequenceFlow)entries.next();
            FlowNode element1 = flow.getSource();
            node.add(element1);
        }
        List<Object> gatewayList = new ArrayList();
        if (isExclusive) {
            if (gateway1.getExclusiveGatewayMap().containsKey(element)) {
                gatewayList = gateway1.getExclusiveGatewayMap().get(element);
                if (gatewayList.size() > 1) {
                    return;
                }
                gatewayList = new ArrayList();
                gatewayList.add(gateway1);
            } else {
                for (int i2 = 0; i2 < node.size(); ++i2) {
                    if (i2 == 0) {
                        gatewayList.add(gateway1);
                        continue;
                    }
                    ProcessAllWay.Gateway gateway_ = new ProcessAllWay.Gateway(processAllWay.getBaseNode());
                    gateway_.setGatewayNode(element);
                    gateway_.getOtherWayList().addAll(gateway1.getOtherWayList());
                    gatewayList.add(gateway_);
                    processAllWay.getGatewayList().add(gateway_);
                }
                gateway1.getExclusiveGatewayMap().put(element, gatewayList);
            }
        }
        for (i = 0; i < node.size(); ++i) {
            FlowNode flowElement = (FlowNode)node.get(i);
            ProcessAllWay.Gateway gateway = null;
            gateway = isExclusive ? (ProcessAllWay.Gateway)gatewayList.get(i) : gateway1;
            if (Objects.equals(flowElement.getElementType().getTypeName(), "exclusiveGateway")) {
                this.selectInAllWay(flowElement, processAllWay, gateway);
                continue;
            }
            if (Objects.equals(flowElement.getElementType().getTypeName(), "parallelGateway")) {
                this.selectInAllWay(flowElement, processAllWay, gateway);
                continue;
            }
            if (gateway.getOtherWayList().contains(flowElement)) continue;
            gateway.add(flowElement);
        }
        if (isExclusive && gatewayList.size() > 1) {
            for (i = 1; i < gatewayList.size(); ++i) {
                gateway1.getGatewayList().add((ProcessAllWay.Gateway)gatewayList.get(i));
            }
        }
    }

    public void startBeforeActivity(ProcessInstanceModificationBuilder re, FlowNode element) {
        UserTask userTask = (UserTask)element;
        MultiInstanceLoopCharacteristics next = null;
        try {
            Collection childElementsByType = userTask.getChildElementsByType(MultiInstanceLoopCharacteristics.class);
            for (MultiInstanceLoopCharacteristics multiInstanceLoopCharacteristics : childElementsByType) {
                this.log.debug("DelegateExecution multiInstanceLoopCharacteristics:{}", (Object)multiInstanceLoopCharacteristics.getId());
                next = multiInstanceLoopCharacteristics;
                if (next == null) continue;
                break;
            }
        }
        catch (Exception e) {
            re.startBeforeActivity(element.getId());
            return;
        }
        if (next == null) {
            re.startBeforeActivity(element.getId());
            return;
        }
        String key = element.getId() + "#multiInstanceBody";
        re.startBeforeActivity(key);
    }
}

