/*
 * Decompiled with CFR 0.152.
 */
package com.manatee.file.process;

import com.alibaba.fastjson.JSONArray;
import com.manatee.common.domain.ResultCode;
import com.manatee.common.exception.BizException;
import com.manatee.common.util.StringUtil;
import com.manatee.lowcode.iutil.IOutputUtil;
import com.manatee.lowcode.util.ProcessConfUtil;
import com.manatee.lowcode.util.VariableUtil;
import com.manatee.process.IProcess;
import com.manatee.process.domain.ProcessContent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Arrays;
import java.util.Objects;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class FileReadProcess
implements IProcess {
    private static Logger LOGGER = LoggerFactory.getLogger(FileReadProcess.class);
    @Resource
    protected IOutputUtil outputUtil;
    @Resource
    private ProcessConfUtil processConfUtil;
    @Resource
    private VariableUtil variableUtil;

    public void process(ProcessContent content) throws BizException {
        String fileSource = content.getStepConf().getString("fileSource");
        Boolean needDel = content.getStepConf().getBoolean("needDel");
        InputStream inputStream = null;
        File file = null;
        if (StringUtil.isBlank((String)fileSource) || "local".equals(fileSource)) {
            this.processConfUtil.checkConf(content, new String[]{"filePath"});
            String filePath = this.variableUtil.calVarInConf(content, "filePath");
            file = new File(filePath);
            try {
                inputStream = new FileInputStream(file);
            }
            catch (FileNotFoundException e) {
                throw new BizException(ResultCode.RESULT_IS_NULL, (Throwable)e);
            }
        } else {
            inputStream = content.getFile();
            if (inputStream == null) {
                throw new BizException(ResultCode.RESULT_IS_NULL, "\u8bf7\u6c42\u53c2\u6570\u4e2d\u6ca1\u6709\u627e\u5230\u6587\u4ef6");
            }
        }
        String confFileSizeStr = content.getStepConfString("fileSize");
        String fileSuffixes = content.getStepConfString("fileSuffixes");
        this.checkFileSize(inputStream, confFileSizeStr);
        this.checkFileSuffixArray(fileSuffixes, content.getFileName());
        StringBuilder value = new StringBuilder();
        JSONArray jsonArray = new JSONArray();
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        Object isReadFileLine = content.getStepConf("isReadFileLine");
        String maxLineStr = content.getStepConfString("maxLine");
        if (StringUtils.isNotBlank((CharSequence)maxLineStr) && !StringUtils.isNumeric((CharSequence)maxLineStr)) {
            throw new BizException(ResultCode.CONF_ERROR, "\u6700\u5927\u8bfb\u53d6\u884c\u6570\uff0c\u5fc5\u987b\u4e3a\u6570\u5b57");
        }
        String str = null;
        try {
            for (int currentLine = 1; !((str = bufferedReader.readLine()) == null || StringUtils.isNotBlank((CharSequence)maxLineStr) && currentLine > Integer.valueOf(maxLineStr)); ++currentLine) {
                if (Objects.equals(isReadFileLine, true)) {
                    jsonArray.add((Object)str);
                    continue;
                }
                value.append(str);
            }
            if (needDel != null && file != null && needDel.booleanValue() && file.exists()) {
                file.delete();
            }
        }
        catch (Exception e) {
            LOGGER.error("FileReadProcess.process error, msg:\u3010\u3011", (Object)e.getMessage());
            throw new BizException((Throwable)e);
        }
        finally {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (IOException e) {
                    LOGGER.error("FileReadProcess.process close error, msg:\u3010\u3011", (Object)e.getMessage());
                }
            }
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    LOGGER.error("FileReadProcess.process close error, msg:\u3010\u3011", (Object)e.getMessage());
                }
            }
        }
        if (Objects.equals(isReadFileLine, true)) {
            this.outputUtil.handleAndPutData(content, (Object)jsonArray);
        } else {
            this.outputUtil.handleAndPutData(content, (Object)value.toString());
        }
    }

    private void checkFileSuffixArray(String fileSuffixes, String fileName) throws BizException {
        if (StringUtils.isEmpty((CharSequence)fileSuffixes)) {
            return;
        }
        String[] fileSuffixArray = StringUtils.split((String)fileSuffixes, (String)",");
        if (Objects.isNull(fileSuffixArray) || fileSuffixArray.length < 1) {
            return;
        }
        for (String singleSuffix : fileSuffixArray) {
            boolean startsWith = StringUtils.startsWith((CharSequence)singleSuffix, (CharSequence)".");
            if (!startsWith) {
                throw new BizException(ResultCode.CONF_ERROR, "\u6587\u4ef6\u8bfb\u53d6\u540e\u7f00\u4fe1\u606f\u914d\u7f6e\u6709\u8bef\uff0c\u5fc5\u987b\u4ee5'.'\u5f00\u5934");
            }
            if (singleSuffix.length() >= 2) continue;
            throw new BizException(ResultCode.CONF_ERROR, "\u6587\u4ef6\u8bfb\u53d6\u540e\u7f00\u4fe1\u606f\u914d\u7f6e\u6709\u8bef\uff0c\u5355\u4e2a\u540e\u7f00\u957f\u5ea6\u5fc5\u987b\u5927\u4e8e\u7b49\u4e8e2");
        }
        Integer lastIndexOf = StringUtils.lastIndexOf((CharSequence)fileName, (CharSequence)".");
        if (lastIndexOf <= 0) {
            throw new BizException(ResultCode.PARAM_IS_ERROR, "\u6587\u4ef6\u7684\u6269\u5c55\u540d\u4e0d\u89c4\u8303");
        }
        String fileSuffix = StringUtils.substring((String)fileName, (int)lastIndexOf);
        boolean contains = Arrays.asList(fileSuffixArray).contains(fileSuffix);
        if (!contains) {
            throw new BizException(ResultCode.PARAM_IS_ERROR, "\u6587\u4ef6\u7684\u6269\u5c55\u540d\u4e0d\u5339\u914d");
        }
    }

    private void checkFileSize(InputStream file, String confFileSizeStr) throws BizException {
        Integer fileSize;
        if (StringUtils.isEmpty((CharSequence)confFileSizeStr)) {
            return;
        }
        try {
            fileSize = file.available() / 1000;
        }
        catch (IOException e) {
            LOGGER.error("FileReadProcess.process file available, msg:\u3010\u3011", (Object)e.getMessage());
            throw new BizException(ResultCode.SYSTEM_ERROR, "\u6587\u4ef6\u5927\u5c0f\u83b7\u53d6\u5931\u8d25", (Throwable)e);
        }
        if (!StringUtils.isNumeric((CharSequence)confFileSizeStr)) {
            throw new BizException(ResultCode.CONF_ERROR, "\u6587\u4ef6\u8bfb\u53d6\u6587\u4ef6\u5927\u5c0f\u4fe1\u606f\u914d\u7f6e\u6709\u8bef\uff0c\u5fc5\u987b\u4e3a\u6570\u5b57");
        }
        Integer confFileSize = Integer.valueOf(confFileSizeStr);
        if (fileSize > confFileSize) {
            throw new BizException(ResultCode.PARAM_IS_ERROR, "\u6587\u4ef6\u8bfb\u53d6\u6587\u4ef6\u5927\u5c0f\u8d85\u51fa\u914d\u7f6e\u9650\u5236");
        }
    }

    public String getName() {
        return "fileReadProcess";
    }
}

